//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _TRACKLIST_H
#define _TRACKLIST_H

#include "gpdlinetool.h"
#include "track.h"
#include "trk_hdr_type.h"
#include "trk_point_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// serveral tracks can be stored with this class
class Tracklist : GPDLineTool
{
   public:
      typedef vector<Track> Tracks;

      /// builds an empty track list
      Tracklist(void);

      /// output to string 
      string os(void);

      /// add data in gpd format
      void is(string);

      /// same as is(string) , for convenience
      void operator<<(string);

      /// returns the number of tracks in the list
      int size(void);
      /// returns the number of tracks in the list
      int sizeTracks(void);

      /// returns the number of trackpoints in track i
      int size(int i);
      /// returns the number of trackpoints in track i
      int sizeTrackpoints(int i);

      /// returns the header of track i in a gpd-string format
      string header(int i);

      /// returns the j-th trackpoint in i-th track
      string trackpoint(int i,int j);
      
      /// return the ith track
      const Track& get(unsigned int i) const { return tracks[i]; }
      
      /// return the ith track
      Track& get(unsigned int i) { return tracks[i]; }
      
      /// get the vector of track
      const Tracks& getList() const { return tracks; }
      
      /// add a track to the list
      void add(Track &track) { tracks.push_back(track); }
      
      /// check whether the track list is empty
      bool empty() const { return tracks.empty(); }
      
      /// clear the track list
      void clear() { tracks.clear(); } 
   
   private:
      Tracks  tracks;
      int current_track;
};

}
#endif
