//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _ROUTELIST_H
#define _ROUTELIST_H

#include "gpdlinetool.h"
#include "route.h"
#include "rte_hdr_type.h"
#include "wpt_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// serveral routes can be stored with this class
class Routelist : GPDLineTool
{
   public:
      typedef vector<Route> Routes;

      /// create an empty route list
      Routelist(void);

      /// output to string 
      string os(void);

      /// add data in gpd format
      void is(string);

      /// same as is(string) , for convenience
      void operator<<(string);

      /// returns the number of routes in the list
      int size(void);
      /// returns the number of routes in the list
      int sizeRoutes(void);

      /// returns the number of routepoints in route i
      int size(int i);
      /// returns the number of routepoints in route i
      int sizeRoutepoints(int i);

      /// returns the header of route i in a gpd-string format
      string header(int i);

      /// returns the j-th routepoint in i-th route
      string routepoint(int i,int j);
   
      /// get the ith route
      const Route& get(unsigned int i) const { return routes[i]; }
      
      /// get the ith route
      Route& get(unsigned int i) { return routes[i]; }
      
      /// get the vector of routes
      const Routes& getList() const { return routes; }
      
      /// add a route to the list
      void add(Route &route) { routes.push_back(route); }
      
      /// check whether the route list is empty
      bool empty() const { return routes.empty(); }
      
      /// clear the list
      void clear() { routes.clear(); } 
   
   private:
      Routes routes;
      int current_route;
};

}
#endif
