//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _IO_H
#define _IO_H

#include "gpdlinetool.h"
#include "waypointlist.h"
#include "routelist.h"
#include "tracklist.h"

#include <iostream> 

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// This class reads gpd from a given stream and puts them in the
/// waypointlist, routlist or tracklist 
class IO : GPDLineTool
{
	public:
		/// Constructor, waypiontlist, routelist and tracklist are given as reference
		IO(Waypointlist &,Routelist &,Tracklist &);

		/// Read the data from instream.
		void operator<<(istream &);

	private:
   	Waypointlist  * waypointlist;
		Routelist * routelist;
		Tracklist * tracklist;
};

}
#endif 
