//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _GPS_H
#define _GPS_H

#include "garmingps.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// This Class does the same things as GarminGPS, but it is easier to use, 
/// it abstrackts away Port handling and other details.
class GPS : GarminGPS
{
   public:
      /// set the Device
      void setDevice(string s){ GarminGPS::setDevice(s);}
      /// set speed for the device
      void setSpeed(string s) { GarminGPS::setSpeed(s); }
      /// download a Waypointlist 
      int downloadWaypoints(Waypointlist &);
      /// upload a Waypointlist
      int uploadWaypoints(Waypointlist &);
      /// download Routes
      int downloadRoutes(Routelist &);
      /// download DateTime
      int downloadDateTime(Date_Time_Type &);
      /// upload Routes
      int uploadRoutes(Routelist &);
      /// download Tracks
      int downloadTracks(Tracklist &);
      /// upload Tracks
      int uploadTracks(Tracklist &);
      /// abort last transfer that my ly around 
      void abortTransfer(void);    
      /// print out a capability Test of the GPS Device
      void printTest(void);
      /// turn off
      void turnOff(void);
      /// return information about connected device or 0 if connection
      /// to device failed
      const DeviceInfo *getInfo() { return GarminGPS::getInfo(); }
};

}
#endif 
