/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = -8796518220218978795L;
    public static final String DEFAULT_KEYMAP = "default";
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private static DefaultTransferHandler defaultTransferHandler;
    private static Hashtable keymaps;
    private Keymap keymap;
    private char focusAccelerator;
    private NavigationFilter navigationFilter;
    private CaretBlinkTimer caretBlinkTimer;
    Document doc;
    Caret caret;
    boolean editable;
    private Highlighter highlighter;
    private Color caretColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private Insets margin;
    private boolean dragEnabled;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;

    public static Keymap getKeymap(String n) {
        return (Keymap)keymaps.get(n);
    }

    public static Keymap removeKeymap(String n) {
        Keymap km = (Keymap)keymaps.get(n);
        keymaps.remove(n);
        return km;
    }

    public static Keymap addKeymap(String n, Keymap parent) {
        DefaultKeymap k = new DefaultKeymap(n);
        k.setResolveParent(parent);
        if (n != null) {
            keymaps.put(n, k);
        }
        return k;
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    /*
     * Unable to fully structure code
     */
    public void setKeymap(Keymap k) {
        block17: {
            block16: {
                kw = k == null ? null : new KeymapWrapper(k);
                childInputMap = this.getInputMap(0);
                if (childInputMap != null) ** GOTO lbl7
                this.setInputMap(0, kw);
                break block16;
lbl-1000:
                // 1 sources

                {
                    childInputMap = childInputMap.getParent();
lbl7:
                    // 2 sources

                    ** while (childInputMap.getParent() != null && !(childInputMap.getParent() instanceof KeymapWrapper) && !(childInputMap.getParent() instanceof InputMapUIResource))
                }
lbl8:
                // 1 sources

                if (childInputMap.getParent() == null) {
                    childInputMap.setParent(kw);
                } else if (childInputMap.getParent() instanceof KeymapWrapper) {
                    if (kw == null) {
                        childInputMap.setParent(childInputMap.getParent().getParent());
                    } else {
                        kw.setParent(childInputMap.getParent().getParent());
                        childInputMap.setParent(kw);
                    }
                } else if (childInputMap.getParent() instanceof InputMapUIResource && kw != null) {
                    kw.setParent(childInputMap.getParent());
                    childInputMap.setParent(kw);
                }
            }
            kam = k == null ? null : new KeymapActionMap(k);
            childActionMap = this.getActionMap();
            if (childActionMap != null) ** GOTO lbl28
            this.setActionMap(kam);
            break block17;
lbl-1000:
            // 1 sources

            {
                childActionMap = childActionMap.getParent();
lbl28:
                // 2 sources

                ** while (childActionMap.getParent() != null && !(childActionMap.getParent() instanceof KeymapActionMap) && !(childActionMap.getParent() instanceof ActionMapUIResource))
            }
lbl29:
            // 1 sources

            if (childActionMap.getParent() == null) {
                childActionMap.setParent(kam);
            } else if (childActionMap.getParent() instanceof KeymapActionMap) {
                if (kam == null) {
                    childActionMap.setParent(childActionMap.getParent().getParent());
                } else {
                    kam.setParent(childActionMap.getParent().getParent());
                    childActionMap.setParent(kam);
                }
            } else if (childActionMap.getParent() instanceof ActionMapUIResource && kam != null) {
                kam.setParent(childActionMap.getParent());
                childActionMap.setParent(kam);
            }
        }
        old = this.keymap;
        this.keymap = k;
        this.firePropertyChange("keymap", old, k);
    }

    public static void loadKeymap(Keymap map, KeyBinding[] bindings, Action[] actions) {
        Hashtable acts = new Hashtable(actions.length);
        int i = 0;
        while (i < actions.length) {
            acts.put(actions[i].getValue("Name"), actions[i]);
            ++i;
        }
        i = 0;
        while (i < bindings.length) {
            if (acts.containsKey(bindings[i].actionName)) {
                map.addActionForKeyStroke(bindings[i].key, (Action)acts.get(bindings[i].actionName));
            }
            ++i;
        }
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public void setDocument(Document newDoc) {
        Document oldDoc = this.doc;
        this.doc = newDoc;
        this.firePropertyChange("document", oldDoc, newDoc);
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        return this.doc;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public void setMargin(Insets m) {
        this.margin = m;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setText(String text) {
        try {
            if (this.doc instanceof AbstractDocument) {
                ((AbstractDocument)this.doc).replace(0, this.doc.getLength(), text, null);
            } else {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, text, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getText() {
        if (this.doc == null) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.getDocument().getText(offset, length);
    }

    public String getSelectedText() {
        try {
            return this.doc.getText(this.getSelectionStart(), this.getSelectionEnd());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public String getUIClassID() {
        return "TextComponentUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI newUI) {
        super.setUI(newUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visible, int orientation, int direction) {
        if (orientation == 0) {
            return visible.width / 10;
        }
        if (orientation == 1) {
            return visible.height / 10;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public int getScrollableBlockIncrement(Rectangle visible, int orientation, int direction) {
        if (orientation == 0) {
            return visible.width;
        }
        if (orientation == 1) {
            return visible.height;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean newValue) {
        if (this.editable == newValue) {
            return;
        }
        if (newValue) {
            this.caretBlinkTimer.start();
        } else {
            this.caretBlinkTimer.stop();
            this.caret.setVisible(false);
        }
        boolean oldValue = this.editable;
        this.editable = newValue;
        this.firePropertyChange("editable", oldValue, newValue);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret newCaret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        this.caretBlinkTimer.update();
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", oldCaret, newCaret);
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color newColor) {
        Color oldCaretColor = this.caretColor;
        this.caretColor = newColor;
        this.firePropertyChange("caretColor", oldCaretColor, newColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color newColor) {
        Color oldColor = this.disabledTextColor;
        this.disabledTextColor = newColor;
        this.firePropertyChange("disabledTextColor", oldColor, newColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color newColor) {
        Color oldColor = this.selectedTextColor;
        this.selectedTextColor = newColor;
        this.firePropertyChange("selectedTextColor", oldColor, newColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color newColor) {
        Color oldColor = this.selectionColor;
        this.selectionColor = newColor;
        this.firePropertyChange("selectionColor", oldColor, newColor);
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.setDot(position);
    }

    public void moveCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.moveDot(position);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter newHighlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter oldHighlighter = this.highlighter;
        this.highlighter = newHighlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", oldHighlighter, newHighlighter);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionStart(int start) {
        this.select(start, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionEnd(int end) {
        this.select(this.getSelectionStart(), end);
    }

    public void select(int start, int end) {
        int length = this.doc.getLength();
        start = Math.max(start, 0);
        start = Math.min(start, length);
        end = Math.max(end, 0);
        end = Math.min(end, length);
        this.setCaretPosition(start);
        this.moveCaretPosition(end);
    }

    public void selectAll() {
        this.select(0, this.doc.getLength());
    }

    public synchronized void replaceSelection(String content) {
        int dot = this.caret.getDot();
        int mark = this.caret.getMark();
        if (content == null) {
            this.caret.setDot(dot);
            return;
        }
        try {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (dot != mark) {
                this.doc.remove(start, end - start);
            }
            this.doc.insertString(start, content, null);
            this.setCaretPosition(start + content.length());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void addCaretListener(CaretListener listener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeCaretListener(CaretListener listener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public CaretListener[] getCaretListeners() {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        return (CaretListener[])this.getListeners(clazz);
    }

    protected void fireCaretUpdate(CaretEvent event) {
        CaretListener[] listeners = this.getCaretListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].caretUpdate(event);
            ++index;
        }
    }

    public void addInputMethodListener(InputMethodListener listener) {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeInputMethodListener(InputMethodListener listener) {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public InputMethodListener[] getInputMethodListeners() {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        return (InputMethodListener[])this.getListeners(clazz);
    }

    public Rectangle modelToView(int position) throws BadLocationException {
        return this.getUI().modelToView(this, position);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int viewToModel(Point pt) {
        return this.getUI().viewToModel(this, pt);
    }

    public void copy() {
        this.doTransferAction("copy", TransferHandler.getCopyAction());
    }

    public void cut() {
        this.doTransferAction("cut", TransferHandler.getCutAction());
    }

    public void paste() {
        this.doTransferAction("paste", TransferHandler.getPasteAction());
    }

    private final void doTransferAction(String name, Action action) {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
        ActionEvent event = new ActionEvent(this, 1001, action.getValue("Name").toString());
        action.actionPerformed(event);
    }

    public void setFocusAccelerator(char newKey) {
        if (this.focusAccelerator == newKey) {
            return;
        }
        char oldKey = this.focusAccelerator;
        this.focusAccelerator = newKey;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, oldKey, newKey);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public void setNavigationFilter(NavigationFilter filter) {
        this.navigationFilter = filter;
    }

    public void read(Reader input, Object streamDescription) throws IOException {
        int c;
        Document d;
        if (streamDescription != null && (d = this.getDocument()) != null) {
            d.putProperty("stream", streamDescription);
        }
        StringBuffer b = new StringBuffer();
        while ((c = input.read()) >= 0) {
            b.append((char)c);
        }
        this.setText(b.toString());
    }

    public void write(Writer output) throws IOException {
        output.write(this.getText());
    }

    public String getToolTipText(MouseEvent ev) {
        return this.getUI().getToolTipText(this, ev.getPoint());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.focusAccelerator = '\u0000';
    }

    public JTextComponent() {
        this.this();
        Keymap defkeymap = JTextComponent.getKeymap(DEFAULT_KEYMAP);
        boolean creatingKeymap = false;
        if (defkeymap == null) {
            defkeymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            defkeymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
            creatingKeymap = true;
        }
        this.caretBlinkTimer = new CaretBlinkTimer();
        this.setFocusable(true);
        this.setEditable(true);
        this.enableEvents(8L);
        this.updateUI();
        if (creatingKeymap) {
            JTextComponent.loadKeymap(defkeymap, new KeyBinding[]{new KeyBinding(KeyStroke.getKeyStroke(37, 0), "caret-backward"), new KeyBinding(KeyStroke.getKeyStroke(39, 0), "caret-forward"), new KeyBinding(KeyStroke.getKeyStroke("typed \b"), "delete-previous"), new KeyBinding(KeyStroke.getKeyStroke("typed \u007f"), "delete-next")}, this.getActions());
        }
    }

    static {
        keymaps = new Hashtable();
    }

    static class DefaultKeymap
    implements Keymap {
        String name;
        Keymap parent;
        Hashtable map;
        Action defaultAction;

        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.map.put(key, a);
        }

        public Action getAction(KeyStroke key) {
            if (this.map.containsKey(key)) {
                return (Action)this.map.get(key);
            }
            if (this.parent != null) {
                return this.parent.getAction(key);
            }
            return null;
        }

        public Action[] getBoundActions() {
            Action[] ret = new Action[this.map.size()];
            Enumeration e = this.map.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (Action)e.nextElement();
            }
            return ret;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] ret = new KeyStroke[this.map.size()];
            Enumeration e = this.map.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (KeyStroke)e.nextElement();
            }
            return ret;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public KeyStroke[] getKeyStrokesForAction(Action a) {
            int i = 0;
            Enumeration e = this.map.keys();
            while (e.hasMoreElements()) {
                if (!this.map.get(e.nextElement()).equals(a)) continue;
                ++i;
            }
            KeyStroke[] ret = new KeyStroke[i];
            i = 0;
            e = this.map.keys();
            while (e.hasMoreElements()) {
                KeyStroke k = (KeyStroke)e.nextElement();
                if (!this.map.get(k).equals(a)) continue;
                ret[i++] = k;
            }
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke key) {
            return this.map.containsKey(key);
        }

        public void removeBindings() {
            this.map.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke key) {
            this.map.remove(key);
        }

        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        public void setResolveParent(Keymap p) {
            this.parent = p;
        }

        public DefaultKeymap(String name) {
            this.name = name;
            this.map = new Hashtable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeymapWrapper
    extends InputMap {
        Keymap map;

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object get(KeyStroke ks) {
            Action mapped = null;
            Keymap m = this.map;
            while (mapped == null && m != null) {
                mapped = m.getAction(ks);
                if (mapped == null && ks.getKeyEventType() == 400) {
                    mapped = m.getDefaultAction();
                }
                if (mapped != null) continue;
                m = m.getResolveParent();
            }
            if (mapped == null) {
                return super.get(ks);
            }
            return mapped;
        }

        public KeyStroke[] keys() {
            KeyStroke[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            KeyStroke[] bothKeys = new KeyStroke[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public KeyStroke[] allKeys() {
            KeyStroke[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            KeyStroke[] bothKeys = new KeyStroke[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public KeymapWrapper(Keymap k) {
            this.map = k;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeymapActionMap
    extends ActionMap {
        Keymap map;

        public Action get(Object cmd) {
            if (cmd instanceof Action) {
                return (Action)cmd;
            }
            return super.get(cmd);
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object[] keys() {
            Object[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public Object[] allKeys() {
            Object[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            int i = 0;
            while (i < superKeys.length) {
                bothKeys[i] = superKeys[i];
                ++i;
            }
            i = 0;
            while (i < mapKeys.length) {
                bothKeys[i + superKeys.length] = mapKeys[i];
                ++i;
            }
            return bothKeys;
        }

        public KeymapActionMap(Keymap k) {
            this.map = k;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke key, String actionName) {
            this.key = key;
            this.actionName = actionName;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CaretBlinkTimer
    extends Timer
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            Caret c = JTextComponent.this.caret;
            if (c != null) {
                c.setVisible(c.isVisible() ^ true);
            }
        }

        public void update() {
            this.stop();
            Caret c = JTextComponent.this.caret;
            if (c != null) {
                this.setDelay(c.getBlinkRate());
                if (JTextComponent.this.editable) {
                    this.start();
                } else {
                    c.setVisible(false);
                }
            }
        }

        public CaretBlinkTimer() {
            super(1000, null);
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DefaultTransferHandler
    extends TransferHandler {
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            JTextComponent textComponent = (JTextComponent)component;
            if (!textComponent.isEnabled() || !textComponent.isEditable() || flavors == null) {
                return false;
            }
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(DataFlavor.stringFlavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void exportToClipboard(JComponent component, Clipboard clipboard, int action) {
            int end;
            JTextComponent textComponent = (JTextComponent)component;
            int start = textComponent.getSelectionStart();
            if (start == (end = textComponent.getSelectionEnd())) {
                return;
            }
            try {
                String data = textComponent.getDocument().getText(start, end);
                StringSelection selection = new StringSelection(data);
                clipboard.setContents(selection, null);
                if (action == 2) {
                    JTextComponent.this.doc.remove(start, end - start);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }

        public int getSourceActions() {
            return 0;
        }

        public boolean importData(JComponent component, Transferable transferable) {
            DataFlavor flavor = null;
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            if (flavors == null) {
                return false;
            }
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(DataFlavor.stringFlavor)) {
                    flavor = flavors[i];
                }
                ++i;
            }
            if (flavor == null) {
                return false;
            }
            try {
                JTextComponent textComponent = (JTextComponent)component;
                String data = (String)transferable.getTransferData(flavor);
                textComponent.replaceSelection(data);
                return true;
            }
            catch (IOException e) {
            }
            catch (UnsupportedFlavorException e) {
                // empty catch block
            }
            return false;
        }

        DefaultTransferHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        private static final long serialVersionUID = 7664188944091413696L;

        public int getCaretPosition() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public void caretUpdate(CaretEvent value0) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public void insertUpdate(DocumentEvent value0) {
        }

        public void removeUpdate(DocumentEvent value0) {
        }

        public void changedUpdate(DocumentEvent value0) {
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        Rectangle getRootEditorRect() {
            return null;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }
    }
}

