/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.charset.EncodingHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;

public class OutputStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 1024;
    private OutputStream out;
    private CharsetEncoder encoder;
    private String encodingName;
    private CharBuffer outputBuffer;

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flush();
        this.out.close();
        this.out = null;
    }

    public String getEncoding() {
        return this.out != null ? this.encodingName : null;
    }

    public void flush() throws IOException {
        if (this.out != null) {
            char[] buf;
            if (this.outputBuffer != null && (buf = new char[this.outputBuffer.position()]).length > 0) {
                this.outputBuffer.flip();
                this.outputBuffer.get(buf);
                this.writeConvert(buf, 0, buf.length);
                this.outputBuffer.clear();
            }
            this.out.flush();
        }
    }

    public void write(char[] buf, int offset, int count) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream is closed.");
        }
        if (buf == null) {
            throw new IOException("Buffer is null.");
        }
        if (this.outputBuffer != null) {
            if (count >= this.outputBuffer.remaining()) {
                int r = this.outputBuffer.remaining();
                this.outputBuffer.put(buf, offset, r);
                this.writeConvert(this.outputBuffer.array(), 0, 1024);
                this.outputBuffer.clear();
                offset += r;
                if ((count -= r) >= this.outputBuffer.remaining()) {
                    this.writeConvert(buf, offset, count);
                    return;
                }
            }
            this.outputBuffer.put(buf, offset, count);
        } else {
            this.writeConvert(buf, offset, count);
        }
    }

    private final void writeConvert(char[] buf, int offset, int count) throws IOException {
        if (this.encoder == null) {
            byte[] b = new byte[count];
            int i = 0;
            while (i < count) {
                b[i] = (byte)(buf[offset + i] <= '\u00ff' ? buf[offset + i] : 63);
                ++i;
            }
            this.out.write(b);
        } else {
            try {
                ByteBuffer output = this.encoder.encode(CharBuffer.wrap(buf, offset, count));
                this.encoder.reset();
                if (output.hasArray()) {
                    this.out.write(output.array());
                } else {
                    byte[] outbytes = new byte[output.remaining()];
                    output.get(outbytes);
                    this.out.write(outbytes);
                }
            }
            catch (IllegalStateException e) {
                throw new IOException("Internal error.");
            }
            catch (MalformedInputException e) {
                throw new IOException("Invalid character sequence.");
            }
            catch (CharacterCodingException e) {
                throw new IOException("Unmappable character.");
            }
        }
    }

    public void write(String str, int offset, int count) throws IOException {
        if (str == null) {
            throw new IOException("String is null.");
        }
        this.write(str.toCharArray(), offset, count);
    }

    public void write(int ch) throws IOException {
        this.write(new char[]{(char)ch}, 0, 1);
    }

    public OutputStreamWriter(OutputStream out, String encoding_scheme) throws UnsupportedEncodingException {
        this.out = out;
        try {
            if (EncodingHelper.isISOLatin1(encoding_scheme)) {
                this.encodingName = "ISO8859_1";
                this.encoder = null;
                return;
            }
            try {
                if (encoding_scheme.equalsIgnoreCase("UnicodeBig") || encoding_scheme.equalsIgnoreCase("UTF-16") || encoding_scheme.equalsIgnoreCase("UTF16")) {
                    encoding_scheme = "UTF-16BE";
                    out.write(-2);
                    out.write(-1);
                } else if (encoding_scheme.equalsIgnoreCase("UnicodeLittle")) {
                    encoding_scheme = "UTF-16LE";
                    out.write(-1);
                    out.write(-2);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.outputBuffer = CharBuffer.allocate(1024);
            Charset cs = EncodingHelper.getCharset(encoding_scheme);
            if (cs == null) {
                throw new UnsupportedEncodingException("Encoding " + encoding_scheme + " unknown");
            }
            this.encoder = cs.newEncoder();
            this.encodingName = EncodingHelper.getOldCanonical(cs.name());
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (RuntimeException e) {
            this.encoder = null;
            this.encodingName = "ISO8859_1";
        }
    }

    public OutputStreamWriter(OutputStream out) {
        this.out = out;
        this.outputBuffer = null;
        try {
            String encoding = System.getProperty("file.encoding");
            Charset cs = Charset.forName(encoding);
            this.encoder = cs.newEncoder();
            this.encodingName = EncodingHelper.getOldCanonical(cs.name());
        }
        catch (RuntimeException e) {
            this.encoder = null;
            this.encodingName = "ISO8859_1";
        }
        if (this.encoder != null) {
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.outputBuffer = CharBuffer.allocate(1024);
        }
    }

    public OutputStreamWriter(OutputStream out, Charset cs) {
        this.out = out;
        this.encoder = cs.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.outputBuffer = CharBuffer.allocate(1024);
    }

    public OutputStreamWriter(OutputStream out, CharsetEncoder enc) {
        this.out = out;
        this.encoder = enc;
        this.outputBuffer = CharBuffer.allocate(1024);
    }
}

