/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferDouble
extends DataBuffer {
    private double[] data;
    private double[][] bankData;

    public final double[] getData() {
        return this.data;
    }

    public final double[] getData(int bank) {
        return this.bankData[bank];
    }

    public final double[][] getBankData() {
        return this.bankData;
    }

    public final int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    public final int getElem(int bank, int i) {
        return (int)this.bankData[bank][i + this.offsets[bank]];
    }

    public final void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    public final void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public final float getElemFloat(int i) {
        return (float)this.data[i + this.offset];
    }

    public final float getElemFloat(int bank, int i) {
        return (float)this.bankData[bank][i + this.offsets[bank]];
    }

    public final void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
    }

    public final void setElemFloat(int bank, int i, float val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public final double getElemDouble(int i) {
        return this.data[i + this.offset];
    }

    public final double getElemDouble(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]];
    }

    public final void setElemDouble(int i, double val) {
        this.data[i + this.offset] = val;
    }

    public final void setElemDouble(int bank, int i, double val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public DataBufferDouble(int size) {
        super(5, size, 1, 0);
        this.bankData = new double[1][];
        this.data = new double[size];
        this.bankData[0] = this.data;
    }

    public DataBufferDouble(int size, int numBanks) {
        super(5, size, numBanks);
        this.bankData = new double[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferDouble(double[] dataArray, int size) {
        super(5, size, 1, 0);
        this.bankData = new double[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferDouble(double[] dataArray, int size, int offset) {
        super(5, size, 1, offset);
        this.bankData = new double[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferDouble(double[][] dataArray, int size) {
        super(5, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferDouble(double[][] dataArray, int size, int[] offsets) {
        super(5, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }
}

