/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends FilterInputStream {
    public static final int CR = 13;
    public static final int LF = 10;
    private boolean doReset;

    public int read() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            this.in.mark(1);
            int d = this.in.read();
            if (d == 10) {
                c = d;
            } else {
                this.in.reset();
            }
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.in.mark(len + 1);
        int l = this.in.read(b, off, len);
        if (l > 0) {
            int i = this.indexOfCRLF(b, off, l);
            if (this.doReset) {
                this.in.reset();
                if (i != -1) {
                    l = this.in.read(b, off, i + 1);
                    this.in.read();
                    b[i] = 10;
                } else {
                    l = this.in.read(b, off, len);
                }
            }
        }
        return l;
    }

    private final int indexOfCRLF(byte[] b, int off, int len) throws IOException {
        this.doReset = false;
        int lm1 = len - 1;
        int i = off;
        while (i < len) {
            if (b[i] == 13) {
                int d;
                if (i == lm1) {
                    d = this.in.read();
                    this.doReset = true;
                } else {
                    d = b[i + 1];
                }
                if (d == 10) {
                    this.doReset = true;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public CRLFInputStream(InputStream in) {
        super(in.markSupported() ? in : new BufferedInputStream(in));
    }
}

