/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalScrollButton
extends BasicArrowButton {
    private static Dimension maximumSize;
    private int buttonWidth;
    private boolean freeStanding;

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setFreeStanding(boolean freeStanding) {
        this.freeStanding = freeStanding;
    }

    public void paint(Graphics g) {
        Rectangle bounds = SwingUtilities.getLocalBounds(this);
        if (this.getModel().isPressed()) {
            g.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            g.setColor(MetalLookAndFeel.getControl());
        }
        g.fillRect(0, 0, bounds.width, bounds.height);
        this.paintArrow(g, bounds.width, bounds.height);
        if (this.freeStanding) {
            if (this.direction == 7) {
                this.paintWestBorderFreeStanding(g, bounds.width, bounds.height);
            } else if (this.direction == 3) {
                this.paintEastBorderFreeStanding(g, bounds.width, bounds.height);
            } else if (this.direction == 5) {
                this.paintSouthBorderFreeStanding(g, bounds.width, bounds.height);
            } else {
                this.paintNorthBorderFreeStanding(g, bounds.width, bounds.height);
            }
        } else if (this.direction == 7) {
            this.paintWestBorder(g, bounds.width, bounds.height);
        } else if (this.direction == 3) {
            this.paintEastBorder(g, bounds.width, bounds.height);
        } else if (this.direction == 5) {
            this.paintSouthBorder(g, bounds.width, bounds.height);
        } else {
            this.paintNorthBorder(g, bounds.width, bounds.height);
        }
    }

    private final void paintArrow(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getBlack());
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
        }
        if (this.direction == 5) {
            int x = w / 2;
            int y = h / 2 + 2;
            int i = 1;
            while (i < 5) {
                g.drawLine(x - i, y - i, x + i - 1, y - i);
                ++i;
            }
        } else if (this.direction == 3) {
            int x = w / 2 + 2;
            int y = h / 2;
            int i = 1;
            while (i < 5) {
                g.drawLine(x - i, y - i, x - i, y + i - 1);
                ++i;
            }
        } else if (this.direction == 7) {
            int x = w / 2 - 3;
            int y = h / 2;
            int i = 1;
            while (i < 5) {
                g.drawLine(x + i, y - i, x + i, y + i - 1);
                ++i;
            }
        } else {
            int x = w / 2;
            int y = h / 2 - 3;
            int i = 1;
            while (i < 5) {
                g.drawLine(x - i, y + i, x + i - 1, y + i);
                ++i;
            }
        }
    }

    private final void paintNorthBorderFreeStanding(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(2, h - 1, w - 2, h - 1);
            g.drawLine(w - 2, 2, w - 2, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 1, 1, h - 1);
            g.drawLine(w - 2, 1, w - 2, 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(0, 0, 0, h - 1);
        }
    }

    private final void paintSouthBorderFreeStanding(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(2, h - 1, w - 2, h - 1);
            g.drawLine(w - 2, 2, w - 2, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 1, 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(0, 0, 0, h - 1);
        }
    }

    private final void paintEastBorderFreeStanding(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(w - 2, 0, w - 2, h - 2);
            g.drawLine(0, h - 2, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, 1, w - 1, 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(w - 2, 1, w - 2, 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
    }

    private final void paintWestBorderFreeStanding(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
    }

    private final void paintNorthBorder(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, 0, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 0, 1, h - 1);
            g.drawLine(1, 0, w - 1, 0);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, 0, h - 1);
        }
    }

    private final void paintSouthBorder(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 0, 1, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 1, 1, h - 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, 0, h - 1);
        }
    }

    private final void paintEastBorder(Graphics g, int w, int h) {
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(w - 1, 2, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, 1, w - 2, 1);
            g.drawLine(0, 1, 0, h - 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, w - 1, 0);
        }
    }

    private final void paintWestBorder(Graphics g, int w, int h) {
        Rectangle bounds = SwingUtilities.getLocalBounds(this);
        if (this.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, bounds.width - 1, 0);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, 1, bounds.width - 1, 1);
            g.drawLine(0, 1, 0, bounds.height - 1);
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            g.drawLine(0, 0, bounds.width - 1, 0);
        }
    }

    public Dimension getPreferredSize() {
        int adj = 1;
        if (!this.freeStanding) {
            adj = 2;
        }
        if (this.direction == 3) {
            return new Dimension(this.buttonWidth - adj, this.buttonWidth);
        }
        if (this.direction == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        if (this.direction == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - adj);
        }
        return new Dimension(this.buttonWidth, this.buttonWidth - 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        if (maximumSize == null) {
            maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return maximumSize;
    }

    public MetalScrollButton(int direction, int width, boolean freeStanding) {
        super(direction);
        this.buttonWidth = width;
        this.freeStanding = freeStanding;
    }
}

