#!/bin/bash --
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
##########################################################################
#
# t12afm.sh
# make an AFM file for a PFA/PFB/TTF/* font file quickly
# by pts@fazekas.hu at Mon Jan  1 21:31:29 CET 2001
#
# needs Ghostscript >=4.30 and printafm.ps (shipped with gs) installed
#
# Note that this quickly generated AFM does not replace the original AFM
# file shipped with the font, because it's rudimentary, might have some
# metrics badly, and contains _no_ kerning and _no_ composite information.
#
# Use this program only if you need a more-or-less exact AFM file _quickly_
# (and temporarily).
#
# Imp: somehow detect that GS cannot load the font specified, so it
#      substitutes
# Imp: filename should not contain (, \, ).
# OK : make FontName correct in AFM (Tue Jun 26 18:14:07 CEST 2001)

#
# Original place: winter:~/tex/minion/bin
#

if [ -z "$1" ]; then
  echo "Usage: $0 FONTNAME.{ttf|pfa|pfb|...} [KPXNAME.kpx]" >&2
  exit 2
fi
if [ ! -f "$1" ]; then
  echo "$0: file not found"
  exit 3
fi

export FONTNAME="`<"$1" perl -ne'if(m@/FontName /(\S+)@){print$1;exit}'`"

GSSTR='
true setglobal % into global VM
% [[ shellarguments not{/zzz}if dup length string copy] 0 get]
% ^^^ create a 1-element list of the filename specified in the command line
[('"$1"')]

Fontmap /_t_F 3 2 roll put false setglobal
% ^^^ put our font into the Fontmap :-)

/_t_F dup findfont /FontName get eq not{
  (%stderr) (w) file dup (fontfile bad/unknown\n) writestring flush quit
}if

1 dict begin LIBPATH{(printafm.ps) 2 copy .filenamedirseparator exch
concatstrings concatstrings dup status{pop pop pop pop/T
exch def}{pop}ifelse}forall T end
% ^^^ find full path of printafm.ps
% Imp: use runlibfile

/shellarguments{(_t_F) true}bind def
% ^^^ set command line of printafm.ps to our /FontName

run % print the AFM file with printafm.ps
quit' 

printafm $1 | perl -ne's@^(FontName ).*@$1$ENV{FONTNAME}@; print unless/^EndFontMetrics/i'
if [ -n "$2" ]; then
  echo 'StartKernData'
  echo "StartKernPairs `<"$2" perl -ne'END{print"$.\n"}'`"
  (printafm $1; cat "$2") | perl -ne '
    BEGIN{@ENC=(".notdef"x256)}
    if($P){s/^KPXX (\d+) (\d+)/KPX $ENC[$1] $ENC[$2]/;
        if ($ENC[$1] ne "" && $ENC[$2] ne "") {print;}
        next}
    if(/^EndFontMetrics/i){$P=1;next}
    if(/^C (\d+).*?N (\S+)/){@ENC[$1]=$2}
  '
  echo 'EndKernPairs'
  echo 'EndKernData'
fi
echo 'EndFontMetrics'
