# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy._core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show_config"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "10.5.0",
                "commands": r"gcc",
                "args": r"-O2, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include",
                "linker args": r"-L/usr/pkg/gcc10/lib/gcc/armv7--netbsdelf-eabihf/10.5.0, -Wl,-R/usr/pkg/gcc10/lib/gcc/armv7--netbsdelf-eabihf/10.5.0, -L/usr/lib, -Wl,-R/usr/lib, -L/usr/pkg/lib, -Wl,-R/usr/pkg/lib, -O2, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.12",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "10.5.0",
                "commands": r"c++",
                "args": r"-O2, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include",
                "linker args": r"-L/usr/pkg/gcc10/lib/gcc/armv7--netbsdelf-eabihf/10.5.0, -Wl,-R/usr/pkg/gcc10/lib/gcc/armv7--netbsdelf-eabihf/10.5.0, -L/usr/lib, -Wl,-R/usr/lib, -L/usr/pkg/lib, -Wl,-R/usr/pkg/lib, -O2, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.10, -I/usr/pkg/include",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "arm",
                "family": "arm",
                "endian": "little",
                "system": "netbsd",
            },
            "build": {
                "cpu": "arm",
                "family": "arm",
                "endian": "little",
                "system": "netbsd",
            },
            "cross-compiled": bool("False".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/pkg/lib/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/pkg/lib/pkgconfig",
            },
        },
        "Python Information": {
            "path": r"/usr/pkg/bin/python3.10",
            "version": "3.10",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )


def show_config(mode=DisplayModes.stdout.value):
    return show(mode)


show_config.__doc__ = show.__doc__
show_config.__module__ = "numpy"
