/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.util.ArrayList;
import java.util.List;
import org.opensolaris.opengrok.history.HistoryEntry;

public class History {
    private List<HistoryEntry> entries;
    private List<String> renamedFiles = new ArrayList<String>();

    public History() {
        this(new ArrayList<HistoryEntry>());
    }

    History(List<HistoryEntry> entries) {
        this.entries = entries;
    }

    History(List<HistoryEntry> entries, List<String> renamed) {
        this.entries = entries;
        this.renamedFiles = renamed;
    }

    public void setHistoryEntries(List<HistoryEntry> entries) {
        this.entries = entries;
    }

    public List<HistoryEntry> getHistoryEntries() {
        return this.entries;
    }

    public boolean hasFileList() {
        for (HistoryEntry entry : this.entries) {
            if (entry.getFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTags() {
        for (HistoryEntry entry : this.entries) {
            if (entry.getTags() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isRenamed(String file) {
        return this.renamedFiles.contains(file);
    }

    public List<String> getRenamedFiles() {
        return this.renamedFiles;
    }
}

