/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.util.ArrayList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.utils.StringUtils;

public class GtpCommand {
    private boolean m_hasId;
    private int m_id;
    private String m_line;
    private final String m_command;
    private final String[] m_arg;
    private final StringBuffer m_response;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpCommand(String string) {
        StringBuffer stringBuffer = GtpCommand.preprocessLine(string);
        if (!$assertionsDisabled && string.trim().equals("")) {
            throw new AssertionError();
        }
        String[] stringArray = StringUtils.splitArguments(stringBuffer.toString());
        if (!$assertionsDisabled && stringArray.length <= 0) {
            throw new AssertionError();
        }
        int n = 0;
        try {
            this.m_id = Integer.parseInt(stringArray[0]);
            this.m_hasId = true;
            this.m_line = stringBuffer.substring(stringArray[0].length()).trim();
            n = 1;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_hasId = false;
            this.m_id = -1;
            this.m_line = stringBuffer.toString();
        }
        this.m_response = new StringBuffer();
        if (n >= stringArray.length) {
            this.m_command = "";
            this.m_arg = null;
            return;
        }
        this.m_command = stringArray[n];
        int n2 = stringArray.length - n - 1;
        this.m_arg = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_arg[i] = stringArray[n + i + 1];
        }
    }

    public void checkArgNone() throws GtpError {
        this.checkNuArg(0);
    }

    public void checkNuArg(int n) throws GtpError {
        if (this.getNuArg() != n) {
            if (n == 0) {
                throw new GtpError("no arguments allowed");
            }
            if (n == 1) {
                throw new GtpError("need argument");
            }
            throw new GtpError("need " + n + " arguments");
        }
    }

    public void checkNuArgLessEqual(int n) throws GtpError {
        if (this.getNuArg() > n) {
            throw new GtpError("too many arguments");
        }
    }

    public boolean hasId() {
        return this.m_hasId;
    }

    public String getArg(int n) throws GtpError {
        if (n >= this.getNuArg()) {
            throw new GtpError("missing argument " + (n + 1));
        }
        return this.m_arg[n];
    }

    public String getArgLine() {
        int n = this.m_line.indexOf(this.m_command) + this.m_command.length();
        return this.m_line.substring(n).trim();
    }

    public String getArgToLower(int n) throws GtpError {
        return this.getArg(n).toLowerCase();
    }

    public GoColor getColorArg() throws GtpError {
        this.checkNuArg(1);
        return this.getColorArg(0);
    }

    public GoColor getColorArg(int n) throws GtpError {
        String string = this.getArgToLower(n);
        if (string.equals("b") || string.equals("black")) {
            return GoColor.BLACK;
        }
        if (string.equals("w") || string.equals("white")) {
            return GoColor.WHITE;
        }
        throw new GtpError("argument " + (n + 1) + " must be black or white");
    }

    public String getCommand() {
        return this.m_command;
    }

    public double getDoubleArg() throws GtpError {
        this.checkNuArg(1);
        return this.getDoubleArg(0);
    }

    public double getDoubleArg(int n) throws GtpError {
        String string = this.getArg(n);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GtpError("argument " + (n + 1) + " must be float");
        }
    }

    public int getIntArg() throws GtpError {
        this.checkNuArg(1);
        return this.getIntArg(0);
    }

    public int getIntArg(int n) throws GtpError {
        String string = this.getArg(n);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GtpError("argument " + (n + 1) + " must be integer");
        }
    }

    public int getIntArg(int n, int n2, int n3) throws GtpError {
        int n4 = this.getIntArg(n);
        if (n4 < n2) {
            throw new GtpError("argument " + (n + 1) + " must be greater/equal " + n2);
        }
        if (n4 > n3) {
            throw new GtpError("argument " + (n + 1) + " must be less/equal " + n3);
        }
        return n4;
    }

    public GoPoint getPointArg(int n, int n2) throws GtpError {
        return GtpUtils.parsePoint(this.getArg(n), n2);
    }

    public ArrayList getPointListArg(int n) throws GtpError {
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>();
        for (int i = 0; i < this.getNuArg(); ++i) {
            arrayList.add(this.getPointArg(i, n));
        }
        return arrayList;
    }

    public String getLine() {
        return this.m_line;
    }

    public int getNuArg() {
        return this.m_arg.length;
    }

    public StringBuffer getResponse() {
        return this.m_response;
    }

    public int getId() {
        return this.m_id;
    }

    public boolean isQuit() {
        return this.m_line.trim().toLowerCase().equals("quit");
    }

    public void setResponse(String string) {
        this.m_response.setLength(0);
        this.m_response.append(string);
    }

    private static StringBuffer preprocessLine(String string) {
        char c;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n && (c = string.charAt(i)) != '#'; ++i) {
            if (Character.isISOControl(c)) continue;
            if (Character.isWhitespace(c)) {
                if (bl) continue;
                stringBuffer.append(' ');
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer;
    }

    static {
        $assertionsDisabled = !GtpCommand.class.desiredAssertionStatus();
    }
}

