/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.TypeCodec;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.UDFContext;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class JavaUDF {
    private final TypeCodec<Object> returnCodec;
    private final TypeCodec<Object>[] argCodecs;
    protected final UDFContext udfContext;

    protected JavaUDF(TypeCodec<Object> returnCodec, TypeCodec<Object>[] argCodecs, UDFContext udfContext) {
        this.returnCodec = returnCodec;
        this.argCodecs = argCodecs;
        this.udfContext = udfContext;
    }

    protected abstract ByteBuffer executeImpl(ProtocolVersion var1, List<ByteBuffer> var2);

    protected abstract Object executeAggregateImpl(ProtocolVersion var1, Object var2, List<ByteBuffer> var3);

    protected Object compose(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        return UDFunction.compose(this.argCodecs, protocolVersion, argIndex, value);
    }

    protected ByteBuffer decompose(ProtocolVersion protocolVersion, Object value) {
        return UDFunction.decompose(this.returnCodec, protocolVersion, value);
    }

    protected float compose_float(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return ((Float)UDHelper.deserialize(TypeCodec.cfloat(), protocolVersion, value)).floatValue();
    }

    protected double compose_double(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Double)UDHelper.deserialize(TypeCodec.cdouble(), protocolVersion, value);
    }

    protected byte compose_byte(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Byte)UDHelper.deserialize(TypeCodec.tinyInt(), protocolVersion, value);
    }

    protected short compose_short(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Short)UDHelper.deserialize(TypeCodec.smallInt(), protocolVersion, value);
    }

    protected int compose_int(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Integer)UDHelper.deserialize(TypeCodec.cint(), protocolVersion, value);
    }

    protected long compose_long(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Long)UDHelper.deserialize(TypeCodec.bigint(), protocolVersion, value);
    }

    protected boolean compose_boolean(ProtocolVersion protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Boolean)UDHelper.deserialize(TypeCodec.cboolean(), protocolVersion, value);
    }
}

