/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.IPasswordRetriever;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.transport.Writer;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.ConnectionErrorException;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.ConnectionWorker;
import com.glavsoft.viewer.RfbConnectionWorker;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.swing.ClipboardControllerImpl;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.gui.PasswordDialog;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SwingRfbConnectionWorker
extends SwingWorker<Void, String>
implements RfbConnectionWorker,
IRfbSessionListener {
    private String predefinedPassword;
    private ConnectionPresenter presenter;
    private JFrame parentWindow;
    private SwingViewerWindowFactory viewerWindowFactory;
    private Logger logger;
    private volatile boolean isStoppingProcess;
    private SwingViewerWindow viewerWindow;
    protected String connectionString;
    protected Protocol workingProtocol;
    protected Socket workingSocket;
    protected ProtocolSettings rfbSettings;
    protected UiSettings uiSettings;

    @Override
    public Void doInBackground() throws Exception {
        if (null == this.workingSocket) {
            throw new ConnectionErrorException("Null socket");
        }
        this.workingSocket.setTcpNoDelay(true);
        Reader reader = new Reader(this.workingSocket.getInputStream());
        Writer writer = new Writer(this.workingSocket.getOutputStream());
        this.workingProtocol = new Protocol(reader, writer, new PasswordChooser(this.connectionString, this.parentWindow, this), this.rfbSettings);
        String message = "Handshaking with remote host";
        this.logger.info(message);
        this.publish(message);
        this.workingProtocol.handshake();
        return null;
    }

    public SwingRfbConnectionWorker(String predefinedPassword, ConnectionPresenter presenter, JFrame parentWindow, SwingViewerWindowFactory viewerWindowFactory) {
        this.predefinedPassword = predefinedPassword;
        this.presenter = presenter;
        this.parentWindow = parentWindow;
        this.viewerWindowFactory = viewerWindowFactory;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.presenter.showMessage("Handshake established");
            ClipboardControllerImpl clipboardController = new ClipboardControllerImpl(this.workingProtocol, this.rfbSettings.getRemoteCharsetName());
            clipboardController.setEnabled(this.rfbSettings.isAllowClipboardTransfer());
            this.rfbSettings.addListener(clipboardController);
            this.viewerWindow = this.viewerWindowFactory.createViewerWindow(this.workingProtocol, this.rfbSettings, this.uiSettings, this.connectionString, this.presenter);
            this.workingProtocol.startNormalHandling(this, this.viewerWindow.getSurface(), clipboardController);
            this.presenter.showMessage("Started");
            this.presenter.successfulRfbConnection();
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled");
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionCancelled();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException ee) {
            String errorMessage;
            String errorTitle;
            try {
                throw ee.getCause();
            }
            catch (UnsupportedProtocolVersionException e) {
                errorTitle = "Unsupported Protocol Version";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (UnsupportedSecurityTypeException e) {
                errorTitle = "Unsupported Security Type";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (AuthenticationFailedException e) {
                errorTitle = "Authentication Failed";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
                this.presenter.clearPredefinedPassword();
            }
            catch (TransportException e) {
                errorTitle = "Connection Error";
                errorMessage = "Connection Error: " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (IOException e) {
                errorTitle = "Connection Error";
                errorMessage = "Connection Error: " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (FatalException e) {
                errorTitle = "Connection Error";
                errorMessage = "Connection Error: " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (Throwable e) {
                errorTitle = "Error";
                errorMessage = "Error: " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            this.presenter.showReconnectDialog(errorTitle, errorMessage);
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void rfbSessionStopped(final String reason) {
        if (this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        if (this.isStoppingProcess) {
            return;
        }
        this.cleanUpUISessionAndConnection();
        this.logger.info("Rfb session stopped: " + reason);
        if (this.presenter.needReconnection()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingRfbConnectionWorker.this.presenter.showReconnectDialog("Connection error", reason);
                    SwingRfbConnectionWorker.this.presenter.reconnect(SwingRfbConnectionWorker.this.predefinedPassword);
                }
            });
        }
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel(true);
        if (res && this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        this.cleanUpUISessionAndConnection();
        return res;
    }

    private synchronized void cleanUpUISessionAndConnection() {
        this.isStoppingProcess = true;
        if (this.workingSocket != null && this.workingSocket.isConnected()) {
            try {
                this.workingSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.viewerWindow != null) {
            this.viewerWindow.close();
        }
        this.isStoppingProcess = false;
    }

    @Override
    public void setWorkingSocket(Socket workingSocket) {
        this.workingSocket = workingSocket;
    }

    @Override
    public void setRfbSettings(ProtocolSettings rfbSettings) {
        this.rfbSettings = rfbSettings;
    }

    @Override
    public void setUiSettings(UiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    private class PasswordChooser
    implements IPasswordRetriever {
        PasswordDialog passwordDialog;
        private String connectionString;
        private final JFrame owner;
        private final ConnectionWorker onCancel;

        private PasswordChooser(String connectionString, JFrame parentWindow, ConnectionWorker onCancel) {
            this.connectionString = connectionString;
            this.owner = parentWindow;
            this.onCancel = onCancel;
        }

        @Override
        public String getPassword() {
            return Strings.isTrimmedEmpty(SwingRfbConnectionWorker.this.predefinedPassword) ? this.getPasswordFromGUI() : SwingRfbConnectionWorker.this.predefinedPassword;
        }

        private String getPasswordFromGUI() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (null == PasswordChooser.this.passwordDialog) {
                            PasswordChooser.this.passwordDialog = new PasswordDialog((Frame)PasswordChooser.this.owner, PasswordChooser.this.onCancel);
                        }
                        PasswordChooser.this.passwordDialog.setServerHostName(PasswordChooser.this.connectionString);
                        PasswordChooser.this.passwordDialog.toFront();
                        PasswordChooser.this.passwordDialog.setVisible(true);
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return this.passwordDialog.getPassword();
        }
    }
}

