/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.actions;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.EditPasteTableNameDlg;
import net.sourceforge.squirrel_sql.plugins.dbcopy.actions.PasteTableUtil;

public class PasteTableAsAction
extends SquirrelAction
implements ISessionAction {
    private final SessionInfoProvider sessionInfoProv;
    private IApplication app = null;
    private static final ILogger log = LoggerController.createLogger(PasteTableAsAction.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PasteTableAsAction.class);

    public PasteTableAsAction(IApplication app, Resources rsrc, DBCopyPlugin plugin) {
        super(app, (IResources)rsrc);
        this.app = app;
        this.sessionInfoProv = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (null == this.sessionInfoProv.getSourceDatabaseObjects()) {
            return;
        }
        Frame owningFrame = SessionUtils.getOwningFrame((ISession)this.sessionInfoProv.getDestSession());
        if (1 != this.sessionInfoProv.getSourceDatabaseObjects().size()) {
            JOptionPane.showMessageDialog(owningFrame, s_stringMgr.getString("EditPasteTableNameDlg.onlyOneTableMsg"));
            return;
        }
        String destTableName = null;
        List selectedTables = this.sessionInfoProv.getDestSession().getObjectTreeAPIOfActiveSessionWindow().getSelectedTables();
        if (1 == selectedTables.size()) {
            destTableName = ((ITableInfo)selectedTables.get(0)).getSimpleName();
        }
        EditPasteTableNameDlg dlg = new EditPasteTableNameDlg(owningFrame, destTableName);
        GUIUtils.centerWithinParent((Window)dlg);
        dlg.setVisible(true);
        if (null == dlg.getTableName()) {
            return;
        }
        PasteTableUtil.excePasteTable(this.sessionInfoProv, this.app, dlg.getTableName());
        System.out.println("dlg.getTableName() = " + dlg.getTableName());
    }

    public void setSession(ISession session) {
        this.sessionInfoProv.setDestSession(session);
    }
}

