/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IJOptionPaneService;

public class JOptionPaneService
implements IJOptionPaneService {
    @Override
    public void showMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
            }
        });
    }

    @Override
    public int showConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType) throws HeadlessException {
        RunnableWithIntResult inputRunner = new RunnableWithIntResult(){
            private int result = -1;

            @Override
            public void run() {
                this.result = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
            }

            @Override
            public int getResult() {
                return this.result;
            }
        };
        GUIUtils.processOnSwingEventThread(inputRunner, true);
        return inputRunner.getResult();
    }

    private static interface RunnableWithIntResult
    extends Runnable {
        public int getResult();
    }
}

