/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.jmeld.util.prefs.Preference;

public class WindowPreference
extends Preference {
    private static String X = "X";
    private static String Y = "Y";
    private static String WIDTH = "WIDTH";
    private static String HEIGHT = "HEIGHT";
    private Window target;

    public WindowPreference(String preferenceName, Window target) {
        super("Window-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        this.target.setLocation(this.getInt(X, 0), this.getInt(Y, 0));
        this.target.setSize(this.getInt(WIDTH, 500), this.getInt(HEIGHT, 400));
        this.target.addWindowListener(this.getWindowListener());
    }

    private void save() {
        this.putInt(X, this.target.getLocation().x);
        this.putInt(Y, this.target.getLocation().y);
        this.putInt(WIDTH, this.target.getSize().width);
        this.putInt(HEIGHT, this.target.getSize().height);
    }

    private WindowListener getWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                WindowPreference.this.save();
            }
        };
    }
}

