/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileSystems;
import sbt.BasicCommandStrings$;
import sbt.State;
import sbt.State$;
import sbt.Watched;
import sbt.internal.io.EventMonitor;
import sbt.internal.io.EventMonitor$;
import sbt.internal.io.Source;
import sbt.internal.io.WatchState;
import sbt.internal.io.WatchState$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.Types$;
import sbt.io.MacOSXWatchService;
import sbt.io.PollingWatchService;
import sbt.io.WatchService;
import sbt.io.WatchService$;
import sbt.util.Logger;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class Watched$ {
    public static Watched$ MODULE$;
    private final Function1<WatchState, String> defaultWatchingMessage;
    private final Function1<WatchState, String> defaultTriggeredMessage;
    private final Function1<WatchState, String> clearWhenTriggered;
    private final FiniteDuration PollDelay;
    private final FiniteDuration AntiEntropy;
    private final AttributeKey<EventMonitor> ContinuousEventMonitor;
    private final AttributeKey<WatchState> ContinuousState;
    private final AttributeKey<WatchService> ContinuousWatchService;
    private final AttributeKey<Watched> Configuration;

    static {
        new Watched$();
    }

    public Function1<WatchState, String> defaultWatchingMessage() {
        return this.defaultWatchingMessage;
    }

    public Function1<WatchState, String> projectWatchingMessage(String projectId) {
        return (Function1 & Serializable & scala.Serializable)ws -> new StringBuilder(70).append(ws.count()).append(". Waiting for source changes in project ").append(projectId).append("... (press enter to interrupt)").toString();
    }

    public Function1<WatchState, String> defaultTriggeredMessage() {
        return this.defaultTriggeredMessage;
    }

    public Function1<WatchState, String> clearWhenTriggered() {
        return this.clearWhenTriggered;
    }

    public String clearScreen() {
        return "\u001b[2J\u001b[0;0H";
    }

    public Watched multi(Watched base, Seq<Watched> paths) {
        return new Watched.AWatched(base, paths){
            private final FiniteDuration pollInterval;
            private final FiniteDuration antiEntropy;
            private final Watched base$1;
            private final Seq paths$1;

            public Seq<Source> watchSources(State s) {
                Seq<Source> seq = this.base$1.watchSources(s);
                return (Seq)this.paths$1.$div$colon(seq, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (Seq)x$2.$plus$plus(x$3.watchSources(s), Seq$.MODULE$.canBuildFrom()));
            }

            public boolean terminateWatch(int key) {
                return this.base$1.terminateWatch(key);
            }

            public FiniteDuration pollInterval() {
                return this.pollInterval;
            }

            public FiniteDuration antiEntropy() {
                return this.antiEntropy;
            }

            public String watchingMessage(WatchState s) {
                return this.base$1.watchingMessage(s);
            }

            public String triggeredMessage(WatchState s) {
                return this.base$1.triggeredMessage(s);
            }
            {
                this.base$1 = base$1;
                this.paths$1 = paths$1;
                Watched watched = base$1;
                this.pollInterval = (FiniteDuration)((TraversableOnce)((TraversableLike)paths$1.$plus$colon((Object)watched, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.pollInterval(), Seq$.MODULE$.canBuildFrom())).min((Ordering)FiniteDuration.FiniteDurationIsOrdered$.MODULE$);
                Watched watched2 = base$1;
                this.antiEntropy = (FiniteDuration)((TraversableOnce)((TraversableLike)paths$1.$plus$colon((Object)watched2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.antiEntropy(), Seq$.MODULE$.canBuildFrom())).min((Ordering)FiniteDuration.FiniteDurationIsOrdered$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$watchSources$1(sbt.State scala.collection.Seq sbt.Watched ), $anonfun$pollInterval$1(sbt.Watched ), $anonfun$antiEntropy$1(sbt.Watched )}, serializedLambda);
            }
        };
    }

    public Watched empty() {
        return new Watched.AWatched();
    }

    public FiniteDuration PollDelay() {
        return this.PollDelay;
    }

    public FiniteDuration AntiEntropy() {
        return this.AntiEntropy;
    }

    public boolean isEnter(int key) {
        return key == 10 || key == 13;
    }

    public void printIfDefined(String msg) {
        block0: {
            if (msg.isEmpty()) break block0;
            System.out.println(msg);
        }
    }

    public State executeContinuously(Watched watched, State s, String next, String repeat) {
        State state;
        Logger log = State$.MODULE$.stateOps(s).log();
        EventMonitor.Logger logger = new EventMonitor.Logger(log){
            private final Logger log$1;

            public void debug(Function0<Object> msg) {
                this.log$1.debug((Function0 & Serializable & scala.Serializable)() -> msg.apply().toString());
            }
            {
                this.log$1 = log$1;
                EventMonitor.Logger.$init$((EventMonitor.Logger)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$debug$1(scala.Function0 )}, serializedLambda);
            }
        };
        Option<EventMonitor> option = State$.MODULE$.stateOps(s).get(this.ContinuousEventMonitor());
        if (None$.MODULE$.equals(option)) {
            String string = BasicCommandStrings$.MODULE$.ClearOnFailure();
            String string2 = next;
            String string3 = State$.MODULE$.FailureWall();
            String string4 = repeat;
            state = State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(s).$colon$colon(string4)).$colon$colon(string3)).$colon$colon(string2)).$colon$colon(string)).put(this.ContinuousEventMonitor(), EventMonitor$.MODULE$.apply(WatchState$.MODULE$.empty(watched.watchService(), watched.watchSources(s)), watched.pollInterval(), watched.antiEntropy(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.shouldTerminate$1(watched), logger));
        } else if (option instanceof Some) {
            State state2;
            boolean triggered;
            boolean bl;
            Some some = (Some)option;
            EventMonitor eventMonitor = (EventMonitor)some.value();
            this.printIfDefined(watched.watchingMessage(eventMonitor.state()));
            try {
                bl = eventMonitor.awaitEvent();
            }
            catch (Exception e) {
                log.error((Function0 & Serializable & scala.Serializable)() -> "Error occurred obtaining files to watch.  Terminating continuous execution...");
                State$.MODULE$.stateOps(s).handleError(e);
                bl = triggered = false;
            }
            if (triggered) {
                this.printIfDefined(watched.triggeredMessage(eventMonitor.state()));
                String string = BasicCommandStrings$.MODULE$.ClearOnFailure();
                String string5 = next;
                String string6 = State$.MODULE$.FailureWall();
                String string7 = repeat;
                state2 = State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(s).$colon$colon(string7)).$colon$colon(string6)).$colon$colon(string5)).$colon$colon(string);
            } else {
                while (System.in.available() > 0) {
                    System.in.read();
                }
                eventMonitor.close();
                state2 = State$.MODULE$.stateOps(s).remove(this.ContinuousEventMonitor());
            }
            state = state2;
        } else {
            throw new MatchError(option);
        }
        return state;
    }

    public AttributeKey<EventMonitor> ContinuousEventMonitor() {
        return this.ContinuousEventMonitor;
    }

    public AttributeKey<WatchState> ContinuousState() {
        return this.ContinuousState;
    }

    public AttributeKey<WatchService> ContinuousWatchService() {
        return this.ContinuousWatchService;
    }

    public AttributeKey<Watched> Configuration() {
        return this.Configuration;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public WatchService createWatchService() {
        String string;
        String string2;
        void var1_10;
        boolean bl = false;
        Some some = null;
        Option option = scala.sys.package$.MODULE$.props().get("sbt.watch.mode");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string3 = (String)some.value();
            if ("polling".equals(string3)) {
                PollingWatchService pollingWatchService = new PollingWatchService(this.PollDelay());
                return var1_10;
            }
        }
        if (bl && "nio".equals(string2 = (String)some.value())) {
            WatchService.WatchServiceAdapter watchServiceAdapter = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
            return var1_10;
        }
        if (bl && "closewatch".equals(string = (String)some.value())) {
            MacOSXWatchService macOSXWatchService = Watched$.closeWatch$1();
            return var1_10;
        }
        if (Properties$.MODULE$.isMac()) {
            MacOSXWatchService macOSXWatchService = Watched$.closeWatch$1();
            return var1_10;
        }
        WatchService.WatchServiceAdapter watchServiceAdapter = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
        return var1_10;
    }

    private final boolean shouldTerminate$1(Watched watched$1) {
        boolean bl;
        block1: {
            while (System.in.available() > 0) {
                if (!watched$1.terminateWatch(System.in.read())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final MacOSXWatchService closeWatch$1() {
        return new MacOSXWatchService();
    }

    private Watched$() {
        MODULE$ = this;
        this.defaultWatchingMessage = (Function1 & Serializable & scala.Serializable)ws -> new StringBuilder(58).append(ws.count()).append(". Waiting for source changes... (press enter to interrupt)").toString();
        this.defaultTriggeredMessage = Types$.MODULE$.const((Object)"");
        this.clearWhenTriggered = Types$.MODULE$.const((Object)this.clearScreen());
        this.PollDelay = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.AntiEntropy = new package.DurationInt(package$.MODULE$.DurationInt(40)).milliseconds();
        this.ContinuousEventMonitor = AttributeKey$.MODULE$.apply("watch event monitor", "Internal: maintains watch state and monitor threads.", ManifestFactory$.MODULE$.classType(EventMonitor.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.ContinuousState = AttributeKey$.MODULE$.apply("watch state", "Internal: tracks state for continuous execution.", ManifestFactory$.MODULE$.classType(WatchState.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.ContinuousWatchService = AttributeKey$.MODULE$.apply("watch service", "Internal: tracks watch service for continuous execution.", ManifestFactory$.MODULE$.classType(WatchService.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.Configuration = AttributeKey$.MODULE$.apply("watched-configuration", "Configures continuous execution.", ManifestFactory$.MODULE$.classType(Watched.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
    }
}

