/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.wiztools.restclient.ui.ISessionView;
import org.wiztools.restclient.ui.SessionTableModel;

class SessionFrame
extends JFrame {
    private final SessionFrame me;
    private final SessionTableModel stm = new SessionTableModel(new String[]{"Request", "Response"});
    private final JTable jt = new JTable(this.stm);

    public SessionFrame(String title) {
        super(title);
        this.me = this;
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.jt.setPreferredSize(new Dimension(200, 300));
        c.add((Component)new JScrollPane(this.jt), "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                int confirmValue = JOptionPane.showConfirmDialog(SessionFrame.this.me, "You will loose any unsaved session data if you\n close the Session Window. Do you want to close?", "Close Session Window?", 0);
                if (confirmValue == 0) {
                    SessionFrame.this.stm.clear();
                    SessionFrame.this.me.setVisible(false);
                }
            }
        });
        this.pack();
    }

    public ISessionView getSessionView() {
        return this.stm;
    }
}

