/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.WorkbenchPanel;

public class MainFrame
extends AbstractFrame {
    private JPanel jContentPane = null;
    private JPanel paneContent = null;
    private JLabel txtStatus = null;
    private WorkbenchPanel paneStandard = null;
    private MainMenuBar mainMenuBar = null;
    private JPanel paneDisplay = null;

    public MainFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getPaneContent());
        this.setSize(800, 600);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.getMainMenuBar().getMenuFileControl().exit();
            }
        });
        this.setVisible(false);
    }

    private JPanel getPaneContent() {
        if (this.paneContent == null) {
            this.paneContent = new JPanel();
            this.paneContent.setLayout(new BoxLayout(this.getPaneContent(), 1));
            this.paneContent.setEnabled(true);
            this.paneContent.setPreferredSize(new Dimension(800, 600));
            this.paneContent.setFont(new Font("Dialog", 0, 12));
            this.paneContent.add((Component)this.getPaneDisplay(), null);
            this.paneContent.add((Component)this.getTxtStatus(), null);
        }
        return this.paneContent;
    }

    private JLabel getTxtStatus() {
        if (this.txtStatus == null) {
            this.txtStatus = new JLabel();
            this.txtStatus.setName("txtStatus");
            this.txtStatus.setText("Initializing...");
            this.txtStatus.setHorizontalAlignment(2);
            this.txtStatus.setHorizontalTextPosition(2);
            this.txtStatus.setPreferredSize(new Dimension(800, 18));
        }
        return this.txtStatus;
    }

    WorkbenchPanel getWorkbench() {
        if (this.paneStandard == null) {
            this.paneStandard = new WorkbenchPanel();
            this.paneStandard.setLayout(new CardLayout());
            this.paneStandard.setName("paneStandard");
        }
        return this.paneStandard;
    }

    public MainMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new MainMenuBar();
        }
        return this.mainMenuBar;
    }

    public void setStatus(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.txtStatus.setText(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    MainFrame.this.txtStatus.setText(string);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JPanel getPaneDisplay() {
        if (this.paneDisplay == null) {
            this.paneDisplay = new JPanel();
            this.paneDisplay.setLayout(new CardLayout());
            this.paneDisplay.setName("paneDisplay");
            this.paneDisplay.add((Component)this.getWorkbench(), this.getWorkbench().getName());
        }
        return this.paneDisplay;
    }
}

