/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestCrossSiteScriptNoBracket
extends AbstractAppParamPlugin {
    private static final String XSS3 = "paros\" style=\"background:url(javascript:alert('" + Constant.getEyeCatcher() + "'))";
    private static final Pattern patternXSS3 = Pattern.compile("<\\w+ +[^>]+paros\" style=\"background:url\\(javascript:alert\\('" + Constant.getEyeCatcher() + "'\\)\\)\".*>");

    public int getId() {
        return 40004;
    }

    public String getName() {
        return "Cross site scripting without brackets";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Cross-site scripting or HTML injection is possible without '<' and '>'.  Malicious script may be injected into the browser which appeared to be genuine content from the original site.  These scripts can be used to execute arbitrary code or steal customer sensitive information such as user password or cookies.\r\nVery often this is in the form of a hyperlink with the injected script embeded in the query strings.  However, XSS is possible via FORM POST data, cookies, user data sent from another user or shared data retrieved from database.\r\nCurrently this check does not verify XSS from cookie or database.  They should be checked manually if the application retrieve database records from another user's input.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Do not trust client side input even if there is client side validation.  Sanitize potentially danger characters in the server side.  Very often filtering the <, >, \" characters prevented injected script to be executed in most cases.  However, sometimes other danger meta-characters such as ' , (, ), /, &, ; etc are also needed.\r\nIn addition (or if these characters are needed), HTML encode meta-characters in the response.  For example, encode < as &lt;\r\n";
        return string;
    }

    public String getReference() {
        String string = "<ul><li>The OWASP guide at http://www.owasp.org/documentation/guide</li><li>http://www.technicalinfo.net/papers/CSS.html</li><li>http://www.cgisecurity.org/articles/xss-faq.shtml</li><li>http://www.cert.org/tech_tips/malicious_code_FAQ.html</li><li>http://sandsprite.com/Sleuth/papers/RealWorld_XSS_1.html</li></ul>";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        this.setParameter(httpMessage, string, XSS3);
        try {
            this.sendAndReceive(httpMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.matchBodyPattern(httpMessage, patternXSS3, stringBuffer)) {
            this.bingo(2, 0, null, string + "=" + XSS3, null, httpMessage);
            return;
        }
    }
}

