/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.natutil;

import java.util.Enumeration;
import uk.ac.ic.doc.natutil.Function;
import uk.ac.ic.doc.natutil.Predicate;
import uk.ac.ic.doc.natutil.Procedure;

public abstract class ImmutableList {
    public static final ImmutableList EMPTY = new ImmutableList(){

        public void forAll(Procedure procedure) {
        }

        public ImmutableList map(Function function) {
            return this;
        }

        public ImmutableList remove(Object object) {
            return this;
        }

        public ImmutableList removeIf(Predicate predicate) {
            return this;
        }
    };

    public final ImmutableList add(Object object) {
        return new Node(object, this);
    }

    public Enumeration elements() {
        return new Enumeration(this){
            private ImmutableList _current;
            {
                this._current = immutableList;
            }

            public boolean hasMoreElements() {
                return this._current != EMPTY;
            }

            public Object nextElement() {
                Object object = ((Node)this._current)._element;
                this._current = ((Node)this._current)._next;
                return object;
            }
        };
    }

    public abstract void forAll(Procedure var1);

    public abstract ImmutableList map(Function var1);

    public abstract ImmutableList remove(Object var1);

    public abstract ImmutableList removeIf(Predicate var1);

    static class Node
    extends ImmutableList {
        private Object _element;
        private ImmutableList _next;

        Node(Object object) {
            this._element = object;
            this._next = EMPTY;
        }

        Node(Object object, ImmutableList immutableList) {
            this._element = object;
            this._next = immutableList;
        }

        public void forAll(Procedure procedure) {
            procedure.execute(this._element);
            this._next.forAll(procedure);
        }

        public ImmutableList map(Function function) {
            return new Node(function.evaluate(this._element), this._next.map(function));
        }

        public ImmutableList remove(Object object) {
            if (this._element == object) {
                return this._next;
            }
            ImmutableList immutableList = this._next.remove(object);
            if (immutableList == this._next) {
                return this;
            }
            return new Node(this._element, immutableList);
        }

        public ImmutableList removeIf(Predicate predicate) {
            ImmutableList immutableList = this._next.remove(predicate);
            if (predicate.evaluate(this._element)) {
                return immutableList;
            }
            if (immutableList == this._next) {
                return this;
            }
            return new Node(this._element, immutableList);
        }
    }
}

