/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory$Maven2RepositoryLayout$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    private float priority;
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Deprecated
    public Maven2RepositoryLayoutFactory() {
        this(new DefaultChecksumAlgorithmFactorySelector());
    }

    @Inject
    public Maven2RepositoryLayoutFactory(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector2 = checksumAlgorithmFactorySelector;
        checksumAlgorithmFactorySelector2.getClass();
        this.checksumAlgorithmFactorySelector = checksumAlgorithmFactorySelector2;
    }

    @Override
    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        List<ChecksumAlgorithmFactory> checksumsAlgorithms = this.checksumAlgorithmFactorySelector.selectList(ConfigUtils.parseCommaSeparatedUniqueNames(ConfigUtils.getString(session, "SHA-1,MD5", "aether.checksums.algorithms")));
        Set omitChecksumsForExtensions = Arrays.stream(ConfigUtils.getString(session, ".asc", "aether.checksums.omitChecksumsForExtensions").split(",")).filter(Maven2RepositoryLayoutFactory$$Lambda$0.INSTANCE).collect(Collectors.toSet());
        if (omitChecksumsForExtensions.stream().anyMatch(Maven2RepositoryLayoutFactory$$Lambda$1.INSTANCE)) {
            throw new IllegalArgumentException(String.format("The configuration %s contains illegal values: %s (all entries must start with '.' (dot))", "aether.checksums.omitChecksumsForExtensions", omitChecksumsForExtensions));
        }
        return new Maven2RepositoryLayout(new ArrayList<ChecksumAlgorithmFactory>(this.checksumAlgorithmFactorySelector.getChecksumAlgorithmFactories()), checksumsAlgorithms, omitChecksumsForExtensions);
    }

    private static /* synthetic */ boolean lambda$newInstance$1(String s) {
        return !s.startsWith(".");
    }

    private static /* synthetic */ boolean lambda$newInstance$0(String s) {
        return s != null && !s.trim().isEmpty();
    }

    static /* synthetic */ boolean accessor$Maven2RepositoryLayoutFactory$lambda0(String string) {
        return Maven2RepositoryLayoutFactory.lambda$newInstance$0(string);
    }

    static /* synthetic */ boolean accessor$Maven2RepositoryLayoutFactory$lambda1(String string) {
        return Maven2RepositoryLayoutFactory.lambda$newInstance$1(string);
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final List<ChecksumAlgorithmFactory> allChecksumAlgorithms;
        private final List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms;
        private final Set<String> extensionsWithoutChecksums;

        private Maven2RepositoryLayout(List<ChecksumAlgorithmFactory> allChecksumAlgorithms, List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms, Set<String> extensionsWithoutChecksums) {
            this.allChecksumAlgorithms = Collections.unmodifiableList(allChecksumAlgorithms);
            this.configuredChecksumAlgorithms = Collections.unmodifiableList(configuredChecksumAlgorithms);
            Set<String> set = extensionsWithoutChecksums;
            set.getClass();
            this.extensionsWithoutChecksums = set;
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
            return this.configuredChecksumAlgorithms;
        }

        public boolean hasChecksums(Artifact artifact) {
            String artifactExtension = artifact.getExtension();
            for (String extensionWithoutChecksums : this.extensionsWithoutChecksums) {
                if (!artifactExtension.endsWith(extensionWithoutChecksums)) continue;
                return false;
            }
            return true;
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        @Override
        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        @Override
        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Artifact artifact, boolean upload, URI location) {
            if (!this.hasChecksums(artifact) || this.isChecksum(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return this.getChecksumLocations(location);
        }

        @Override
        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Metadata metadata, boolean upload, URI location) {
            return this.getChecksumLocations(location);
        }

        private List<RepositoryLayout.ChecksumLocation> getChecksumLocations(URI location) {
            ArrayList<RepositoryLayout.ChecksumLocation> checksumLocations = new ArrayList<RepositoryLayout.ChecksumLocation>(this.configuredChecksumAlgorithms.size());
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : this.configuredChecksumAlgorithms) {
                checksumLocations.add(RepositoryLayout.ChecksumLocation.forLocation(location, checksumAlgorithmFactory));
            }
            return checksumLocations;
        }

        private boolean isChecksum(String extension) {
            String string = extension;
            return this.allChecksumAlgorithms.stream().anyMatch(new Maven2RepositoryLayoutFactory$Maven2RepositoryLayout$$Lambda$0(string));
        }

        static /* synthetic */ boolean accessor$Maven2RepositoryLayoutFactory$Maven2RepositoryLayout$lambda0(String string, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            return string.endsWith("." + checksumAlgorithmFactory.getFileExtension());
        }
    }
}

