/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private static final Logger LOG = Log.getLogger(DefaultServlet.class);
    private static final long serialVersionUID = 4930458713846881193L;
    private static final HttpGenerator.CachedHttpField ACCEPT_RANGES = new HttpGenerator.CachedHttpField(HttpHeader.ACCEPT_RANGES, "bytes");
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _welcomeServlets = false;
    private boolean _welcomeExactServlets = false;
    private boolean _redirectWelcome = false;
    private boolean _gzip = false;
    private boolean _pathInfoOnly = false;
    private boolean _etags = false;
    private Resource _resourceBase;
    private ResourceCache _cache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private Resource _stylesheet;
    private boolean _useFileMappedBuffer = false;
    private HttpField _cacheControl;
    private String _relativeResourceBase;
    private ServletHandler _servletHandler;
    private ServletHolder _defaultHolder;
    private List<String> _gzipEquivalentFileExtensions;

    public void init() throws UnavailableException {
        this._servletContext = this.getServletContext();
        this._contextHandler = this.initContextHandler(this._servletContext);
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._pathInfoOnly = this.getInitBoolean("pathInfoOnly", this._pathInfoOnly);
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeResourceBase = this.getInitParameter("relativeResourceBase");
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            if (this._relativeResourceBase != null) {
                throw new UnavailableException("resourceBase & relativeResourceBase");
            }
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource((String)css);
                if (!this._stylesheet.exists()) {
                    LOG.warn("!" + css, new Object[0]);
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = Resource.newResource((URL)((Object)((Object)this)).getClass().getResource("/jetty-dir.css"));
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug((Throwable)e);
        }
        String cc = this.getInitParameter("cacheControl");
        if (cc != null) {
            this._cacheControl = new HttpGenerator.CachedHttpField(HttpHeader.CACHE_CONTROL, cc);
        }
        String resourceCache = this.getInitParameter("resourceCache");
        int max_cache_size = this.getInitInt("maxCacheSize", -2);
        int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
        int max_cached_files = this.getInitInt("maxCachedFiles", -2);
        if (resourceCache != null) {
            if (max_cache_size != -1 || max_cached_file_size != -2 || max_cached_files != -2) {
                LOG.debug("ignoring resource cache configuration, using resourceCache attribute", new Object[0]);
            }
            if (this._relativeResourceBase != null || this._resourceBase != null) {
                throw new UnavailableException("resourceCache specified with resource bases");
            }
            this._cache = (ResourceCache)this._servletContext.getAttribute(resourceCache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache {}={}", new Object[]{resourceCache, this._cache});
            }
        }
        this._etags = this.getInitBoolean("etags", this._etags);
        try {
            if (this._cache == null && (max_cached_files != -2 || max_cache_size != -2 || max_cached_file_size != -2)) {
                this._cache = new ResourceCache(null, (ResourceFactory)this, this._mimeTypes, this._useFileMappedBuffer, this._etags);
                if (max_cache_size >= 0) {
                    this._cache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._cache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._cache.setMaxCachedFiles(max_cached_files);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
            throw new UnavailableException(e.toString());
        }
        this._gzipEquivalentFileExtensions = new ArrayList<String>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                this._gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            this._gzipEquivalentFileExtensions.add(".svgz");
        }
        this._servletHandler = (ServletHandler)this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        for (ServletHolder h : this._servletHandler.getServlets()) {
            if (h.getServletInstance() != this) continue;
            this._defaultHolder = h;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resource base = " + this._resourceBase, new Object[0]);
        }
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        if (scontext == null) {
            if (servletContext instanceof ContextHandler.Context) {
                return ((ContextHandler.Context)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + servletContext + " " + servletContext.getClass().getName() + " is not " + ContextHandler.Context.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter("org.eclipse.jetty.servlet.Default." + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    public Resource getResource(String pathInContext) {
        Resource r = null;
        if (this._relativeResourceBase != null) {
            pathInContext = URIUtil.addPaths((String)this._relativeResourceBase, (String)pathInContext);
        }
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
                if (!this._contextHandler.checkAlias(pathInContext, r)) {
                    r = null;
                }
            } else if (this._servletContext instanceof ContextHandler.Context) {
                r = this._contextHandler.getResource(pathInContext);
            } else {
                URL u = this._servletContext.getResource(pathInContext);
                r = this._contextHandler.newResource(u);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource " + pathInContext + "=" + r, new Object[0]);
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
        if ((r == null || !r.exists()) && pathInContext.endsWith("/jetty-dir.css")) {
            r = this._stylesheet;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block51: {
            String servletPath = null;
            String pathInfo = null;
            Enumeration reqRanges = null;
            Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
            if (included != null && included.booleanValue()) {
                servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (servletPath == null) {
                    servletPath = request.getServletPath();
                    pathInfo = request.getPathInfo();
                }
            } else {
                included = Boolean.FALSE;
                servletPath = this._pathInfoOnly ? "/" : request.getServletPath();
                pathInfo = request.getPathInfo();
                reqRanges = request.getHeaders(HttpHeader.RANGE.asString());
                if (!this.hasDefinedRange(reqRanges)) {
                    reqRanges = null;
                }
            }
            String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
            boolean endsWithSlash = (pathInfo == null ? request.getServletPath() : pathInfo).endsWith("/");
            Resource resource = null;
            HttpContent content = null;
            boolean close_content = true;
            try {
                String pathInContextGz = null;
                boolean gzip = false;
                if (!included.booleanValue() && this._gzip && reqRanges == null && !endsWithSlash) {
                    pathInContextGz = pathInContext + ".gz";
                    if (this._cache == null) {
                        resource = this.getResource(pathInContextGz);
                    } else {
                        content = this._cache.lookup(pathInContextGz);
                        Resource resource2 = resource = content == null ? null : content.getResource();
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) {
                        response.addHeader(HttpHeader.VARY.asString(), HttpHeader.ACCEPT_ENCODING.asString());
                        String accept = request.getHeader(HttpHeader.ACCEPT_ENCODING.asString());
                        if (accept != null && accept.indexOf("gzip") >= 0) {
                            gzip = true;
                        }
                    }
                }
                if (!gzip) {
                    if (this._cache == null) {
                        resource = this.getResource(pathInContext);
                    } else {
                        content = this._cache.lookup(pathInContext);
                        Resource resource3 = resource = content == null ? null : content.getResource();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("uri=%s, resource=%s, content=%s", request.getRequestURI(), resource, content), new Object[0]);
                }
                if (resource == null || !resource.exists()) {
                    if (included.booleanValue()) {
                        throw new FileNotFoundException("!" + pathInContext);
                    }
                    response.sendError(404);
                    break block51;
                }
                if (!resource.isDirectory()) {
                    if (endsWithSlash && pathInContext.length() > 1) {
                        String q = request.getQueryString();
                        pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                        if (q != null && q.length() != 0) {
                            pathInContext = pathInContext + "?" + q;
                        }
                        response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths((String)this._servletContext.getContextPath(), (String)pathInContext)));
                    } else {
                        if (content == null) {
                            content = new HttpContent.ResourceAsHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), response.getBufferSize(), this._etags);
                        }
                        if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                            if (gzip || this.isGzippedContent(pathInContext)) {
                                response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), "gzip");
                                String mt = this._servletContext.getMimeType(pathInContext);
                                if (mt != null) {
                                    response.setContentType(mt);
                                }
                            }
                            close_content = this.sendData(request, response, included, resource, content, reqRanges);
                        }
                    }
                    break block51;
                }
                String welcome = null;
                if (!endsWithSlash || pathInContext.length() == 1 && request.getAttribute("org.eclipse.jetty.server.nullPathInfo") != null) {
                    StringBuffer buf;
                    StringBuffer stringBuffer = buf = request.getRequestURL();
                    synchronized (stringBuffer) {
                        int param = buf.lastIndexOf(";");
                        if (param < 0) {
                            buf.append('/');
                        } else {
                            buf.insert(param, '/');
                        }
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                        break block51;
                    }
                }
                welcome = this.getWelcomeFile(pathInContext);
                if (null != welcome) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("welcome={}", new Object[]{welcome});
                    }
                    if (this._redirectWelcome) {
                        response.setContentLength(0);
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths((String)this._servletContext.getContextPath(), (String)welcome) + "?" + q));
                        } else {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths((String)this._servletContext.getContextPath(), (String)welcome)));
                        }
                    } else {
                        RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                        if (dispatcher != null) {
                            if (included.booleanValue()) {
                                dispatcher.include((ServletRequest)request, (ServletResponse)response);
                            } else {
                                request.setAttribute("org.eclipse.jetty.server.welcome", (Object)welcome);
                                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                            }
                        }
                    }
                } else {
                    content = new HttpContent.ResourceAsHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), this._etags);
                    if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                        this.sendDirectory(request, response, resource, pathInContext);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
                if (!response.isCommitted()) {
                    response.sendError(500, e.getMessage());
                }
            }
            finally {
                if (close_content) {
                    if (content != null) {
                        content.release();
                    } else if (resource != null) {
                        resource.close();
                    }
                }
            }
        }
    }

    protected boolean isGzippedContent(String path) {
        if (path == null) {
            return false;
        }
        for (String suffix : this._gzipEquivalentFileExtensions) {
            if (!path.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefinedRange(Enumeration<String> reqRanges) {
        return reqRanges != null && reqRanges.hasMoreElements();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this._welcomes == null) {
            return null;
        }
        String welcome_servlet = null;
        for (int i = 0; i < this._welcomes.length; ++i) {
            PathMap.MappedEntry<ServletHolder> entry;
            String welcome_in_context = URIUtil.addPaths((String)pathInContext, (String)this._welcomes[i]);
            Resource welcome = this.getResource(welcome_in_context);
            if (welcome != null && welcome.exists()) {
                return this._welcomes[i];
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcome_servlet != null || (entry = this._servletHandler.getHolderEntry(welcome_in_context)) == null || entry.getValue() == this._defaultHolder || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getKey().equals(welcome_in_context))) continue;
            welcome_servlet = welcome_in_context;
        }
        return welcome_servlet;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        try {
            if (!HttpMethod.HEAD.is(request.getMethod())) {
                long date;
                String ifms;
                if (this._etags) {
                    String if_non_match_etag;
                    String tag;
                    QuotedStringTokenizer quoted;
                    String ifm = request.getHeader(HttpHeader.IF_MATCH.asString());
                    if (ifm != null) {
                        boolean match = false;
                        if (content.getETag() != null) {
                            quoted = new QuotedStringTokenizer(ifm, ", ", false, true);
                            while (!match && quoted.hasMoreTokens()) {
                                tag = quoted.nextToken();
                                if (!content.getETag().equals(tag)) continue;
                                match = true;
                            }
                        }
                        if (!match) {
                            response.setStatus(412);
                            return false;
                        }
                    }
                    if ((if_non_match_etag = request.getHeader(HttpHeader.IF_NONE_MATCH.asString())) != null && content.getETag() != null) {
                        if (content.getETag().equals(request.getAttribute("o.e.j.s.GzipFilter.ETag"))) {
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), if_non_match_etag);
                            return false;
                        }
                        if (content.getETag().equals(if_non_match_etag)) {
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETag());
                            return false;
                        }
                        quoted = new QuotedStringTokenizer(if_non_match_etag, ", ", false, true);
                        while (quoted.hasMoreTokens()) {
                            tag = quoted.nextToken();
                            if (!content.getETag().equals(tag)) continue;
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETag());
                            return false;
                        }
                        return true;
                    }
                }
                if ((ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString())) != null) {
                    String mdlm = content.getLastModified();
                    if (mdlm != null && ifms.equals(mdlm)) {
                        response.setStatus(304);
                        if (this._etags) {
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETag());
                        }
                        response.flushBuffer();
                        return false;
                    }
                    long ifmsl = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                    if (ifmsl != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                        response.setStatus(304);
                        if (this._etags) {
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETag());
                        }
                        response.flushBuffer();
                        return false;
                    }
                }
                if ((date = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString())) != -1L && resource.lastModified() / 1000L > date / 1000L) {
                    response.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                response.sendError(400, iae.getMessage());
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        String dir;
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths((String)request.getRequestURI(), (String)"/");
        if (this._resourceBase != null) {
            if (this._resourceBase instanceof ResourceCollection) {
                resource = this._resourceBase.addPath(pathInContext);
            }
        } else if (this._contextHandler.getBaseResource() instanceof ResourceCollection) {
            resource = this._contextHandler.getBaseResource().addPath(pathInContext);
        }
        if ((dir = resource.getListHTML(base, pathInContext.length() > 1)) == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected boolean sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, final HttpContent content, Enumeration<String> reqRanges) throws IOException {
        boolean written;
        long content_length = content == null ? resource.length() : content.getContentLength();
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            written = out instanceof HttpOutput ? ((HttpOutput)out).isWritten() : true;
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream((Writer)response.getWriter());
            written = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("sendData content=%s out=%s async=%b", content, out, request.isAsyncSupported()), new Object[0]);
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                resource.writeTo((OutputStream)out, 0L, content_length);
            } else if (content == null || written || !(out instanceof HttpOutput)) {
                ByteBuffer buffer;
                this.writeHeaders(response, content, written ? -1L : content_length);
                ByteBuffer byteBuffer = buffer = content == null ? null : content.getIndirectBuffer();
                if (buffer != null) {
                    BufferUtil.writeTo((ByteBuffer)buffer, (OutputStream)out);
                } else {
                    resource.writeTo((OutputStream)out, 0L, content_length);
                }
            } else {
                if (response instanceof Response) {
                    Response r = (Response)response;
                    this.writeOptionHeaders(r.getHttpFields());
                    r.setHeaders(content);
                } else {
                    this.writeHeaders(response, content, content_length);
                }
                if (request.isAsyncSupported()) {
                    final AsyncContext context = request.startAsync();
                    context.setTimeout(0L);
                    ((HttpOutput)out).sendContent(content, new Callback(){

                        public void succeeded() {
                            context.complete();
                            content.release();
                        }

                        public void failed(Throwable x) {
                            if (x instanceof IOException) {
                                LOG.debug(x);
                            } else {
                                LOG.warn(x);
                            }
                            context.complete();
                            content.release();
                        }

                        public String toString() {
                            return String.format("DefaultServlet@%x$CB", ((Object)((Object)DefaultServlet.this)).hashCode());
                        }
                    });
                    return false;
                }
                ((HttpOutput)out).sendContent(content);
            }
        } else {
            InclusiveByteRange ibr;
            int i;
            String mimetype;
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, (long)content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), InclusiveByteRange.to416HeaderRangeString((long)content_length));
                resource.writeTo((OutputStream)out, 0L, content_length);
                return true;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                if (!response.containsHeader(HttpHeader.DATE.asString())) {
                    response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
                }
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return true;
            }
            this.writeHeaders(response, content, -1L);
            String string = mimetype = content == null ? null : content.getContentType();
            if (mimetype == null) {
                LOG.warn("Unknown mimetype for " + request.getRequestURI(), new Object[0]);
            }
            MultiPartOutputStream multi = new MultiPartOutputStream((OutputStream)out);
            response.setStatus(206);
            if (!response.containsHeader(HttpHeader.DATE.asString())) {
                response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
            }
            String ctp = request.getHeader(HttpHeader.REQUEST_RANGE.asString()) != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            int length = 0;
            String[] header = new String[ranges.size()];
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                header[i] = ibr.toHeaderRangeString(content_length);
                length = (int)((long)length + ((long)((i > 0 ? 2 : 0) + 2 + multi.getBoundary().length() + 2 + (mimetype == null ? 0 : HttpHeader.CONTENT_TYPE.asString().length() + 2 + mimetype.length()) + 2 + HttpHeader.CONTENT_RANGE.asString().length() + 2 + header[i].length() + 2 + 2) + (ibr.getLast(content_length) - ibr.getFirst(content_length)) + 1L));
            }
            response.setContentLength(length += 4 + multi.getBoundary().length() + 2 + 2);
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                multi.startPart(mimetype, new String[]{HttpHeader.CONTENT_RANGE + ": " + header[i]});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy((InputStream)in, (OutputStream)multi, (long)size);
                    pos += size;
                    continue;
                }
                resource.writeTo((OutputStream)multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
        return true;
    }

    protected void writeHeaders(HttpServletResponse response, HttpContent content, long count) {
        if (content == null) {
            return;
        }
        if (content.getContentType() != null && response.getContentType() == null) {
            response.setContentType(content.getContentType().toString());
        }
        if (response instanceof Response) {
            long lml;
            Response r = (Response)response;
            HttpFields fields = r.getHttpFields();
            if (content.getLastModified() != null) {
                fields.put(HttpHeader.LAST_MODIFIED, content.getLastModified());
            } else if (content.getResource() != null && (lml = content.getResource().lastModified()) != -1L) {
                fields.putDateField(HttpHeader.LAST_MODIFIED, lml);
            }
            if (count != -1L) {
                r.setLongContentLength(count);
            }
            this.writeOptionHeaders(fields);
            if (this._etags) {
                fields.put(HttpHeader.ETAG, content.getETag());
            }
        } else {
            long lml = content.getResource().lastModified();
            if (lml >= 0L) {
                response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), lml);
            }
            if (count != -1L) {
                if (count < Integer.MAX_VALUE) {
                    response.setContentLength((int)count);
                } else {
                    response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(count));
                }
            }
            this.writeOptionHeaders(response);
            if (this._etags) {
                response.setHeader(HttpHeader.ETAG.asString(), content.getETag());
            }
        }
    }

    protected void writeOptionHeaders(HttpFields fields) {
        if (this._acceptRanges) {
            fields.put((HttpField)ACCEPT_RANGES);
        }
        if (this._cacheControl != null) {
            fields.put(this._cacheControl);
        }
    }

    protected void writeOptionHeaders(HttpServletResponse response) {
        if (this._acceptRanges) {
            response.setHeader(HttpHeader.ACCEPT_RANGES.asString(), "bytes");
        }
        if (this._cacheControl != null) {
            response.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl.getValue());
        }
    }

    public void destroy() {
        if (this._cache != null) {
            this._cache.flushCache();
        }
        super.destroy();
    }
}

