/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.api.BaseQuotaTest;
import kafka.server.ConfigEntityName$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaId;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.Before;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001\u001d\u0011Q#V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u000e\u0005\u0006\u001cX-U;pi\u0006$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u0015\t\u0002\u0001\"\u0015\u0013\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001\u0014!\t!\u0002%D\u0001\u0016\u0015\t1r#\u0001\u0003bkRD'B\u0001\r\u001a\u0003!\u0019XmY;sSRL(B\u0001\u000e\u001c\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"+\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\tG\u0001A)\u0019!C)I\u0005qAO];tiN#xN]3GS2,W#A\u0013\u0011\u0007\u0019J3&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0011\u0019v.\\3\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013AA5p\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\t\u0019KG.\u001a\u0005\bi\u0001\u0011\r\u0011\"\u00116\u00035)8/\u001a:Qe&t7-\u001b9bYV\ta\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:_\u0005!A.\u00198h\u0013\tY\u0004H\u0001\u0004TiJLgn\u001a\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u001c\u0002\u001dU\u001cXM\u001d)sS:\u001c\u0017\u000e]1mA!)q\b\u0001C!k\u0005\u0001\u0002O]8ek\u000e,'o\u00117jK:$\u0018\n\u001a\u0005\u0006\u0003\u0002!\t%N\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012DQa\u0011\u0001\u0005B\u0011\u000bq\u0002\u001d:pIV\u001cWM])v_R\f\u0017\nZ\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005);%aB)v_R\f\u0017\n\u001a\u0005\u0006\u0019\u0002!\t\u0005R\u0001\u0010G>t7/^7feF+x\u000e^1JI\")a\n\u0001C!\u001f\u0006)1/\u001a;VaR\t\u0001\u000b\u0005\u0002'#&\u0011!k\n\u0002\u0005+:LG\u000f\u000b\u0002N)B\u0011Q\u000bW\u0007\u0002-*\u0011qKH\u0001\u0006UVt\u0017\u000e^\u0005\u00033Z\u0013aAQ3g_J,\u0007\"B.\u0001\t\u0003b\u0016AD8wKJ\u0014\u0018\u000eZ3Rk>$\u0018m\u001d\u000b\u0005!v\u0013G\rC\u0003_5\u0002\u0007q,A\u0007qe>$WoY3s#V|G/\u0019\t\u0003M\u0001L!!Y\u0014\u0003\t1{gn\u001a\u0005\u0006Gj\u0003\raX\u0001\u000eG>t7/^7feF+x\u000e^1\t\u000b\u0015T\u0006\u0019\u00014\u0002\u0019I,\u0017/^3tiF+x\u000e^1\u0011\u0005\u0019:\u0017B\u00015(\u0005\u0019!u.\u001e2mK\")!\u000e\u0001C!\u001f\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKNDQ\u0001\u001c\u0001\u0005\n5\f1#\u001e9eCR,\u0017+^8uC>3XM\u001d:jI\u0016$B\u0001\u00158zw\")Ag\u001ba\u0001_B\u0011\u0001o\u001e\b\u0003cV\u0004\"A]\u0014\u000e\u0003MT!\u0001\u001e\u0004\u0002\rq\u0012xn\u001c;?\u0013\t1x%\u0001\u0004Qe\u0016$WMZ\u0005\u0003waT!A^\u0014\t\u000bi\\\u0007\u0019A8\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012DQ\u0001`6A\u0002u\f!\u0002\u001d:pa\u0016\u0014H/[3t!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0018\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u000by(A\u0003)s_B,'\u000f^5fg\u0002")
public class UserClientIdQuotaTest
extends BaseQuotaTest {
    private Some<File> trustStoreFile;
    private final String userPrincipal;
    private volatile boolean bitmap$0;

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SSL;
    }

    private Some<File> trustStoreFile$lzycompute() {
        UserClientIdQuotaTest userClientIdQuotaTest = this;
        synchronized (userClientIdQuotaTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public String userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public String producerClientId() {
        return "QuotasTestProducer-!@#$%^&*()";
    }

    @Override
    public String consumerClientId() {
        return "QuotasTestConsumer-!@#$%^&*()";
    }

    @Override
    public QuotaId producerQuotaId() {
        return new QuotaId((Option)new Some((Object)Sanitizer.sanitize((String)this.userPrincipal())), (Option)new Some((Object)this.producerClientId()), (Option)new Some((Object)Sanitizer.sanitize((String)this.producerClientId())));
    }

    @Override
    public QuotaId consumerQuotaId() {
        return new QuotaId((Option)new Some((Object)Sanitizer.sanitize((String)this.userPrincipal())), (Option)new Some((Object)this.consumerClientId()), (Option)new Some((Object)Sanitizer.sanitize((String)this.consumerClientId())));
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        super.setUp();
        Properties defaultProps = this.quotaProperties(this.defaultProducerQuota(), this.defaultConsumerQuota(), this.defaultRequestQuota());
        this.adminZkClient().changeUserOrUserClientIdConfig(ConfigEntityName$.MODULE$.Default() + "/clients/" + ConfigEntityName$.MODULE$.Default(), defaultProps);
        this.waitForQuotaUpdate(this.defaultProducerQuota(), this.defaultConsumerQuota(), this.defaultRequestQuota());
    }

    @Override
    public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
        Properties producerProps = new Properties();
        producerProps.setProperty(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        producerProps.setProperty(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.producerClientId(), producerProps);
        Properties consumerProps = new Properties();
        consumerProps.setProperty(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        consumerProps.setProperty(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.userPrincipal(), this.consumerClientId(), consumerProps);
    }

    @Override
    public void removeQuotaOverrides() {
        Properties emptyProps = new Properties();
        this.adminZkClient().changeUserOrUserClientIdConfig(Sanitizer.sanitize((String)this.userPrincipal()) + "/clients/" + Sanitizer.sanitize((String)this.producerClientId()), emptyProps);
        this.adminZkClient().changeUserOrUserClientIdConfig(Sanitizer.sanitize((String)this.userPrincipal()) + "/clients/" + Sanitizer.sanitize((String)this.consumerClientId()), emptyProps);
    }

    private void updateQuotaOverride(String userPrincipal, String clientId, Properties properties) {
        this.adminZkClient().changeUserOrUserClientIdConfig(Sanitizer.sanitize((String)userPrincipal) + "/clients/" + Sanitizer.sanitize((String)clientId), properties);
    }

    public UserClientIdQuotaTest() {
        this.userPrincipal = "O=A client,CN=localhost";
    }
}

