/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.rest.JettyBundleActivatorConfig;
import org.jitsi.rest.JettyHelpers;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.MainKt;
import org.jitsi.videobridge.VersionConfig;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.rest.root.Application;
import org.jitsi.videobridge.stats.MucStatsTransport;
import org.jitsi.videobridge.stats.StatsCollector;
import org.jitsi.videobridge.stats.VideobridgeStatistics;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.version.JvbVersionService;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import org.jxmpp.stringprep.XmppStringPrepUtil;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\b\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"getSystemPropertyDefaults", "", "", "main", "", "setSystemPropertyDefaults", "setupMetaconfigLogger", "startIce4j", "stopIce4j", "jitsi-videobridge"})
public final class MainKt {
    public static final void main() {
        Server server;
        Server server2;
        LoggerImpl logger = new LoggerImpl("org.jitsi.videobridge.Main");
        MainKt.setupMetaconfigLogger();
        MainKt.setSystemPropertyDefaults();
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.JavaUtilLog");
        JitsiConfig.Companion.reloadNewConfig();
        JvbVersionService jvbVersionService = new JvbVersionService();
        Object it = jvbVersionService;
        boolean bl = false;
        logger.info("Starting jitsi-videobridge version " + ((JvbVersionService)it).getCurrentVersion());
        JvbVersionService versionService = jvbVersionService;
        MainKt.startIce4j();
        XmppStringPrepUtil.setMaxCacheSizes(XmppClientConnectionConfig.config.getJidCacheSize());
        PacketQueue.setEnableStatisticsDefault(true);
        Object $this$main_u24lambda_u2d1 = it = new XmppConnection();
        boolean bl2 = false;
        ((XmppConnection)$this$main_u24lambda_u2d1).start();
        Object xmppConnection = it;
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Videobridge $this$main_u24lambda_u2d2 = bl2 = new Videobridge((XmppConnection)xmppConnection, shutdownService, versionService.getCurrentVersion(), VersionConfig.config.getRelease(), Clock.systemUTC());
        boolean bl3 = false;
        $this$main_u24lambda_u2d2.start();
        Videobridge videobridge = bl2;
        JvbHealthChecker jvbHealthChecker = videobridge.getJvbHealthChecker();
        Intrinsics.checkNotNullExpressionValue(jvbHealthChecker, "videobridge.jvbHealthChecker");
        JvbHealthChecker healthChecker2 = jvbHealthChecker;
        StatsCollector $this$main_u24lambda_u2d3 = bl3 = new StatsCollector(new VideobridgeStatistics(videobridge, (XmppConnection)xmppConnection));
        boolean bl4 = false;
        $this$main_u24lambda_u2d3.start();
        $this$main_u24lambda_u2d3.addTransport(new MucStatsTransport((XmppConnection)xmppConnection), XmppClientConnectionConfig.config.getPresenceInterval().toMillis());
        StatsCollector statsCollector = bl3;
        JettyBundleActivatorConfig publicServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest", "videobridge.http-servers.public");
        if (JettyHelpers.isEnabled(publicServerConfig)) {
            Server server3;
            logger.info("Starting public http server");
            ColibriWebSocketService websocketService = new ColibriWebSocketService(publicServerConfig.isTls());
            ColibriWebSocketServiceSupplierKt.singleton().setColibriWebSocketService(websocketService);
            Server it2 = server3 = JettyHelpers.createServer(publicServerConfig);
            boolean bl5 = false;
            websocketService.registerServlet(JettyHelpers.getServletContextHandler(it2), videobridge);
            it2.start();
            server2 = server3;
        } else {
            logger.info("Not starting public http server");
            server2 = null;
        }
        Server publicHttpServer = server2;
        JettyBundleActivatorConfig privateServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest.private", "videobridge.http-servers.private");
        if (JettyHelpers.isEnabled(privateServerConfig)) {
            Server server4;
            logger.info("Starting private http server");
            Application restApp = new Application(videobridge, (XmppConnection)xmppConnection, statsCollector, versionService.getCurrentVersion(), healthChecker2);
            Server it3 = server4 = JettyHelpers.createServer(privateServerConfig);
            boolean bl6 = false;
            JettyHelpers.getServletContextHandler(it3).addServlet(new ServletHolder(new ServletContainer(restApp)), "/*");
            JettyHelpers.enableCors$default(JettyHelpers.getServletContextHandler(it3), null, 1, null);
            it3.start();
            server = server4;
        } else {
            logger.info("Not starting private http server");
            server = null;
        }
        Server privateHttpServer = server;
        shutdownService.waitForShutdown();
        logger.info("Bridge shutting down");
        healthChecker2.stop();
        ((XmppConnection)xmppConnection).stop();
        statsCollector.stop();
        try {
            Server server5 = publicHttpServer;
            if (server5 != null) {
                server5.stop();
            }
            Server server6 = privateHttpServer;
            if (server6 != null) {
                server6.stop();
            }
        }
        catch (Throwable t) {
            logger.error("Error shutting down http servers", t);
        }
        videobridge.stop();
        MainKt.stopIce4j();
        TaskPools.SCHEDULED_POOL.shutdownNow();
        TaskPools.CPU_POOL.shutdownNow();
        TaskPools.IO_POOL.shutdownNow();
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void setupMetaconfigLogger() {
        LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger(configLogger){
            final /* synthetic */ LoggerImpl $configLogger;
            {
                this.$configLogger = $configLogger;
            }

            public void warn(@NotNull Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.warn(() -> setupMetaconfigLogger.1.warn$lambda-0(block));
            }

            public void error(@NotNull Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.error(() -> setupMetaconfigLogger.1.error$lambda-1(block));
            }

            public void debug(@NotNull Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.debug(() -> setupMetaconfigLogger.1.debug$lambda-2(block));
            }

            private static final String warn$lambda-0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String error$lambda-1(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String debug$lambda-2(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }
        });
    }

    private static final void setSystemPropertyDefaults() {
        Map<String, String> defaults;
        Map<String, String> $this$forEach$iv = defaults = MainKt.getSystemPropertyDefaults();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value2);
        }
    }

    private static final Map<String, String> getSystemPropertyDefaults() {
        Map defaults;
        block1: {
            List<String> ice4jPropNames;
            defaults = new LinkedHashMap();
            ConfigurationService cfg = JitsiConfig.Companion.getSipCommunicatorProps();
            List<String> list = ice4jPropNames = cfg.getPropertyNamesByPrefix("org.ice4j", false);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String key = (String)element$iv;
                boolean bl = false;
                String string2 = string = cfg.getString(key);
                if (string2 == null) continue;
                Intrinsics.checkNotNullExpressionValue(string2, "getString(key)");
                String value2 = string;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(key, "key");
                defaults.put(key, value2);
            }
        }
        return defaults;
    }

    private static final void startIce4j() {
        ThreadsKt.thread$default(true, false, null, null, 0, startIce4j.1.INSTANCE, 30, null);
    }

    private static final void stopIce4j() {
        Harvesters.closeStaticConfiguration();
    }

    public static /* synthetic */ void main(String[] args2) {
        MainKt.main();
    }
}

