/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public abstract class AuthConfigFactory {
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";
    private static final String DEFAULT_JASPI_AUTHCONFIGFACTORYIMPL = "org.apache.geronimo.components.jaspi.AuthConfigFactoryImpl";
    private static AuthConfigFactory factory;
    private static ClassLoader contextClassLoader;

    public static AuthConfigFactory getFactory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getAuthConfigFactory"));
        }
        if (factory == null) {
            String className = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty(AuthConfigFactory.DEFAULT_FACTORY_SECURITY_PROPERTY);
                }
            });
            if (className == null) {
                className = DEFAULT_JASPI_AUTHCONFIGFACTORYIMPL;
            }
            try {
                final String finalClassName = className;
                factory = (AuthConfigFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        return Class.forName(finalClassName, true, contextClassLoader).newInstance();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception inner = e.getException();
                if (inner instanceof InstantiationException) {
                    throw (SecurityException)new SecurityException("AuthConfigFactory error:" + inner.getCause().getMessage()).initCause(inner.getCause());
                }
                throw (SecurityException)new SecurityException("AuthConfigFactory error: " + inner).initCause(inner);
            }
        }
        return factory;
    }

    public static void setFactory(AuthConfigFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setAuthConfigFactory"));
        }
        AuthConfigFactory.factory = factory;
    }

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract void refresh();

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract String registerConfigProvider(String var1, Map var2, String var3, String var4, String var5);

    public abstract boolean removeRegistration(String var1);

    static {
        contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static interface RegistrationContext {
        public String getAppContext();

        public String getDescription();

        public String getMessageLayer();

        public boolean isPersistent();
    }
}

