/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmp;

import net.sf.gogui.gmp.Gmp;

class Cmd {
    public static final int OK = 0;
    public static final int DENY = 1;
    public static final int NEWGAME = 2;
    public static final int QUERY = 3;
    public static final int ANSWER = 4;
    public static final int MOVE = 5;
    public static final int UNDO = 6;
    public static final int EXTENDED = 7;
    public static final int MASK_MOVE_COLOR = 512;
    public static final int MASK_MOVE_POINT = 511;
    public static final int QUERY_GAME = 0;
    public static final int QUERY_BUFSIZE = 1;
    public static final int QUERY_VERSION = 2;
    public static final int QUERY_NUMSTONES = 3;
    public static final int QUERY_TIMEBLACK = 4;
    public static final int QUERY_TIMEWHITE = 5;
    public static final int QUERY_CHARSET = 6;
    public static final int QUERY_RULES = 7;
    public static final int QUERY_HANDICAP = 8;
    public static final int QUERY_SIZE = 9;
    public static final int QUERY_TIMELIMIT = 10;
    public static final int QUERY_COLOR = 11;
    public static final int QUERY_WHO = 12;
    public int m_cmd;
    public int m_val;

    public Cmd(int n, int n2) {
        this.m_cmd = n;
        this.m_val = n2;
    }

    public static String answerValToString(int n, int n2) {
        boolean bl = true;
        switch (n2) {
            case 0: {
                if (n == 1) {
                    return "GO";
                }
                if (n == 2) {
                    return "CHESS";
                }
                if (n != 3) break;
                return "OTHELLO";
            }
            case 1: {
                return Integer.toString(4 + n * 16) + " BYTES";
            }
            case 2: {
                bl = false;
                break;
            }
            case 6: {
                if (n == 1) {
                    return "ASCII";
                }
                if (n != 2) break;
                return "JAPANESE";
            }
            case 7: {
                if (n == 1) {
                    return "JAPANESE";
                }
                if (n != 2) break;
                return "CHINESE (SST)";
            }
            case 8: {
                if (n != 1) break;
                return "NONE";
            }
            case 11: {
                if (n == 1) {
                    return "WHITE";
                }
                if (n != 2) break;
                return "BLACK";
            }
            case 12: {
                if (n == 1) {
                    return "NEMESIS";
                }
                if (n == 2) {
                    return "MANY FACES OF GO";
                }
                if (n == 3) {
                    return "SMART GO BOARD";
                }
                if (n == 4) {
                    return "GOLIATH";
                }
                if (n == 5) {
                    return "GO INTELLECT";
                }
                if (n != 6) break;
                return "STAR OF POLAND";
            }
        }
        if (n == 0 && bl) {
            return "UNKNOWN";
        }
        return Integer.toString(n);
    }

    public static String cmdToString(int n) {
        switch (n) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "DENY";
            }
            case 2: {
                return "NEWGAME";
            }
            case 3: {
                return "QUERY";
            }
            case 4: {
                return "ANSWER";
            }
            case 5: {
                return "MOVE";
            }
            case 6: {
                return "UNDO";
            }
            case 7: {
                return "EXTENDED";
            }
        }
        return Integer.toString(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Cmd) {
            Cmd cmd = (Cmd)object;
            return cmd.m_cmd == this.m_cmd && cmd.m_val == this.m_val;
        }
        return false;
    }

    public int hashCode() {
        return this.m_cmd << 16 | this.m_val;
    }

    public static String moveValToString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if ((n & 0x200) == 0) {
            stringBuffer.append("B ");
        } else {
            stringBuffer.append("W ");
        }
        if (n2 == 0) {
            stringBuffer.append(n & 0x1FF);
        } else {
            Gmp.Move move = Cmd.parseMove(n, n2);
            if (move.m_x < 0 || move.m_y < 0) {
                stringBuffer.append("PASS");
            } else {
                int n3 = 65 + move.m_x;
                if (n3 >= 73) {
                    ++n3;
                }
                char c = (char)n3;
                stringBuffer.append(c);
                stringBuffer.append(move.m_y + 1);
            }
        }
        return stringBuffer.toString();
    }

    public static Gmp.Move parseMove(int n, int n2) {
        Gmp.Move move = new Gmp.Move();
        boolean bl = move.m_isBlack = (n & 0x200) == 0;
        if ((n &= 0x1FF) == 0) {
            move.m_x = -1;
            move.m_y = -1;
        } else {
            move.m_x = --n % n2;
            move.m_y = n / n2;
        }
        return move;
    }

    public static String queryValToString(int n) {
        switch (n) {
            case 0: {
                return "GAME";
            }
            case 1: {
                return "BUFSIZE";
            }
            case 2: {
                return "VERSION";
            }
            case 3: {
                return "NUMSTONES";
            }
            case 4: {
                return "TIMEBLACK";
            }
            case 5: {
                return "TIMEWHITE";
            }
            case 6: {
                return "CHARSET";
            }
            case 7: {
                return "RULES";
            }
            case 8: {
                return "HANDICAP";
            }
            case 9: {
                return "SIZE";
            }
            case 10: {
                return "TIMELIMIT";
            }
            case 11: {
                return "COLOR";
            }
            case 12: {
                return "WHO";
            }
        }
        return "? (" + Integer.toString(n) + ")";
    }

    public String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(Cmd.cmdToString(this.m_cmd));
        switch (this.m_cmd) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                stringBuffer.append(' ');
                stringBuffer.append(Cmd.queryValToString(this.m_val));
                break;
            }
            case 4: {
                stringBuffer.append(' ');
                stringBuffer.append(Cmd.answerValToString(this.m_val, n2));
                break;
            }
            case 5: {
                stringBuffer.append(' ');
                stringBuffer.append(Cmd.moveValToString(this.m_val, n));
                break;
            }
            default: {
                stringBuffer.append(' ');
                stringBuffer.append(this.m_val);
            }
        }
        return stringBuffer.toString();
    }
}

