/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.BookmarkDialog;
import net.sf.gogui.gui.OptionalMessage;

public class EditBookmarksDialog
extends JOptionPane {
    private static final long serialVersionUID = 0L;
    private final ActionListener m_actionListener;
    private JButton m_edit;
    private JButton m_moveDown;
    private JButton m_moveUp;
    private JButton m_remove;
    private final JList m_list;
    private OptionalMessage m_removeWarning;
    private final ArrayList m_bookmarks;
    static /* synthetic */ Class class$net$sf$gogui$gui$EditBookmarksDialog;

    public static boolean show(Component component, ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        EditBookmarksDialog.copyBookmarks(arrayList, arrayList2);
        EditBookmarksDialog editBookmarksDialog = new EditBookmarksDialog(arrayList2);
        JDialog jDialog = editBookmarksDialog.createDialog(component, "Edit Bookmarks");
        jDialog.setVisible(true);
        Object object = editBookmarksDialog.getValue();
        boolean bl = true;
        if (!(object instanceof Integer) || (Integer)object != 0) {
            bl = false;
        }
        jDialog.dispose();
        if (bl) {
            EditBookmarksDialog.copyBookmarks(arrayList2, arrayList);
        }
        return bl;
    }

    public EditBookmarksDialog(ArrayList arrayList) {
        this.m_bookmarks = arrayList;
        this.m_actionListener = new ActionListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("edit")) {
                    EditBookmarksDialog.this.cbEdit();
                } else if (string.equals("move-up")) {
                    EditBookmarksDialog.this.cbMoveUp();
                } else if (string.equals("move-down")) {
                    EditBookmarksDialog.this.cbMoveDown();
                } else if (string.equals("remove")) {
                    EditBookmarksDialog.this.cbRemove();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$net$sf$gogui$gui$EditBookmarksDialog == null ? (class$net$sf$gogui$gui$EditBookmarksDialog = EditBookmarksDialog.class$("net.sf.gogui.gui.EditBookmarksDialog")) : class$net$sf$gogui$gui$EditBookmarksDialog).desiredAssertionStatus();
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        this.m_list = new JList();
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditBookmarksDialog.this.selectionChanged();
            }
        });
        this.m_list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.createButtonPanel(), "East");
        this.setMessage(jPanel);
        this.setOptionType(2);
        this.updateList(this.m_bookmarks.size() == 0 ? -1 : 0);
    }

    private void cbMoveDown() {
        int n = this.m_list.getSelectedIndex();
        if (n < 0 || n >= this.m_bookmarks.size() - 1) {
            return;
        }
        Object e = this.m_bookmarks.get(n);
        this.m_bookmarks.set(n, this.m_bookmarks.get(n + 1));
        this.m_bookmarks.set(n + 1, e);
        this.updateList(n + 1);
    }

    private void cbEdit() {
        Bookmark bookmark = this.getSelected();
        if (bookmark == null) {
            return;
        }
        int n = this.m_list.getSelectedIndex();
        Bookmark bookmark2 = new Bookmark(bookmark);
        if (!BookmarkDialog.show(this, "Edit Bookmark", bookmark2, false)) {
            return;
        }
        bookmark.copyFrom(bookmark2);
        this.updateList(n);
    }

    private void cbMoveUp() {
        int n = this.m_list.getSelectedIndex();
        if (n < 0 || n == 0) {
            return;
        }
        Object e = this.m_bookmarks.get(n);
        this.m_bookmarks.set(n, this.m_bookmarks.get(n - 1));
        this.m_bookmarks.set(n - 1, e);
        this.updateList(n - 1);
    }

    private void cbRemove() {
        Bookmark bookmark = this.getSelected();
        if (bookmark == null) {
            return;
        }
        int n = this.m_list.getSelectedIndex();
        String string = bookmark.m_name;
        if (this.m_removeWarning == null) {
            this.m_removeWarning = new OptionalMessage(this);
        }
        if (!this.m_removeWarning.showWarning("Really remove '" + string + "'?")) {
            return;
        }
        this.m_bookmarks.remove(bookmark);
        if (n >= this.m_bookmarks.size()) {
            n = -1;
        }
        this.updateList(n);
    }

    private static void copyBookmarks(ArrayList arrayList, ArrayList arrayList2) {
        arrayList2.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(new Bookmark((Bookmark)arrayList.get(i)));
        }
    }

    private JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(false);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.m_actionListener);
        return jButton;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        this.m_moveUp = this.createButton("Move Up", "move-up");
        jPanel.add(this.m_moveUp);
        this.m_moveDown = this.createButton("Move Down", "move-down");
        jPanel.add(this.m_moveDown);
        this.m_edit = this.createButton("Edit", "edit");
        jPanel.add(this.m_edit);
        this.m_remove = this.createButton("Remove", "remove");
        jPanel.add(this.m_remove);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private Bookmark getBookmark(int n) {
        return (Bookmark)this.m_bookmarks.get(n);
    }

    private Bookmark getSelected() {
        int n = this.m_list.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getBookmark(n);
    }

    private void selectionChanged() {
        int n = this.m_list.getSelectedIndex();
        this.m_edit.setEnabled(n >= 0);
        this.m_remove.setEnabled(n >= 0);
        this.m_moveUp.setEnabled(n >= 1);
        this.m_moveDown.setEnabled(n < this.m_bookmarks.size() - 1);
    }

    private void updateList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_bookmarks.size(); ++i) {
            String string = this.getBookmark((int)i).m_name;
            arrayList.add(string);
        }
        this.m_list.setListData(arrayList.toArray());
        this.m_list.setSelectedIndex(n);
    }
}

