/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

public final class NVPair {
    private String name;
    private String value;
    private String encoding = "8859_1";
    private boolean defaultEncoding = true;

    public NVPair(String name, String value, String encoding) {
        this.name = name;
        this.value = value;
        if (encoding != null) {
            this.encoding = encoding;
            this.defaultEncoding = false;
        }
    }

    public NVPair(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public NVPair(NVPair p) {
        this(p.name, p.value, p.safeGetEncoding());
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",value=" + this.value + (!this.defaultEncoding ? ", encoding=" + this.encoding : "") + "]";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.defaultEncoding = false;
    }

    public boolean isDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String safeGetEncoding() {
        return this.defaultEncoding ? null : this.encoding;
    }
}

