/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.ActiveMQMessage;
import org.apache.activemq.apollo.openwire.command.Message;
import org.apache.activemq.apollo.openwire.support.MarshallingSupport;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.Settings;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

public class ActiveMQTextMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 28;
    protected String text;

    public Message copy() {
        ActiveMQTextMessage copy = new ActiveMQTextMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQTextMessage copy) {
        super.copy(copy);
        copy.text = this.text;
    }

    public byte getDataStructureType() {
        return 28;
    }

    public String getJMSXMimeType() {
        return "jms/text-message";
    }

    public void setText(String text) throws OpenwireException {
        this.checkReadOnlyBody();
        this.text = text;
        this.setContent(null);
    }

    public String getText() throws OpenwireException {
        if (this.text == null && this.getContent() != null) {
            InputStream is = null;
            try {
                Buffer bodyAsBytes = this.getContent();
                if (bodyAsBytes != null) {
                    is = new ByteArrayInputStream(bodyAsBytes);
                    if (this.isCompressed()) {
                        is = new InflaterInputStream(is);
                    }
                    DataInputStream dataIn = new DataInputStream(is);
                    this.text = MarshallingSupport.readUTF8(dataIn);
                    dataIn.close();
                    this.setContent(null);
                    this.setCompressed(false);
                }
            }
            catch (IOException ioe) {
                throw new OpenwireException(ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.text;
    }

    public void beforeMarshall(OpenWireFormat wireFormat) throws IOException {
        super.beforeMarshall(wireFormat);
        Buffer content = this.getContent();
        if (content == null && this.text != null) {
            ByteArrayOutputStream bytesOut;
            Object os = bytesOut = new ByteArrayOutputStream();
            if (Settings.enable_compression()) {
                this.compressed = true;
                os = new DeflaterOutputStream((OutputStream)os);
            }
            DataOutputStream dataOut = new DataOutputStream((OutputStream)os);
            MarshallingSupport.writeUTF8(dataOut, this.text);
            dataOut.close();
            this.setContent(bytesOut.toBuffer());
        }
    }

    public void afterMarshall(OpenWireFormat wireFormat) throws IOException {
        super.afterMarshall(wireFormat);
        this.text = null;
    }

    public void clearMarshalledState() {
        super.clearMarshalledState();
        this.text = null;
    }

    public void clearBody() throws OpenwireException {
        super.clearBody();
        this.text = null;
    }

    public int getSize() {
        if (this.size == 0 && this.content == null && this.text != null) {
            this.size = this.getMinimumMessageSize();
            if (this.marshalledProperties != null) {
                this.size += this.marshalledProperties.getLength();
            }
            this.size = this.text.length() * 2;
        }
        return super.getSize();
    }

    public String toString() {
        try {
            String text = this.getText();
            if (text != null) {
                text = MarshallingSupport.truncate64(text);
                HashMap<String, Object> overrideFields = new HashMap<String, Object>();
                overrideFields.put("text", text);
                return super.toString(overrideFields);
            }
        }
        catch (OpenwireException openwireException) {
            // empty catch block
        }
        return super.toString();
    }
}

