/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.thrift.IndexType;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ColumnDef
implements TBase<ColumnDef, _Fields>,
Serializable,
Cloneable,
Comparable<ColumnDef> {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnDef");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField VALIDATION_CLASS_FIELD_DESC = new TField("validation_class", 11, 2);
    private static final TField INDEX_TYPE_FIELD_DESC = new TField("index_type", 8, 3);
    private static final TField INDEX_NAME_FIELD_DESC = new TField("index_name", 11, 4);
    private static final TField INDEX_OPTIONS_FIELD_DESC = new TField("index_options", 13, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer name;
    public String validation_class;
    public IndexType index_type;
    public String index_name;
    public Map<String, String> index_options;
    private _Fields[] optionals = new _Fields[]{_Fields.INDEX_TYPE, _Fields.INDEX_NAME, _Fields.INDEX_OPTIONS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ColumnDef() {
    }

    public ColumnDef(ByteBuffer name, String validation_class) {
        this();
        this.name = name;
        this.validation_class = validation_class;
    }

    public ColumnDef(ColumnDef other) {
        if (other.isSetName()) {
            this.name = TBaseHelper.copyBinary((ByteBuffer)other.name);
        }
        if (other.isSetValidation_class()) {
            this.validation_class = other.validation_class;
        }
        if (other.isSetIndex_type()) {
            this.index_type = other.index_type;
        }
        if (other.isSetIndex_name()) {
            this.index_name = other.index_name;
        }
        if (other.isSetIndex_options()) {
            HashMap<String, String> __this__index_options = new HashMap<String, String>(other.index_options);
            this.index_options = __this__index_options;
        }
    }

    public ColumnDef deepCopy() {
        return new ColumnDef(this);
    }

    public void clear() {
        this.name = null;
        this.validation_class = null;
        this.index_type = null;
        this.index_name = null;
        this.index_options = null;
    }

    public byte[] getName() {
        this.setName(TBaseHelper.rightSize((ByteBuffer)this.name));
        return this.name == null ? null : this.name.array();
    }

    public ByteBuffer bufferForName() {
        return this.name;
    }

    public ColumnDef setName(byte[] name) {
        this.setName(name == null ? (ByteBuffer)null : ByteBuffer.wrap(name));
        return this;
    }

    public ColumnDef setName(ByteBuffer name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public String getValidation_class() {
        return this.validation_class;
    }

    public ColumnDef setValidation_class(String validation_class) {
        this.validation_class = validation_class;
        return this;
    }

    public void unsetValidation_class() {
        this.validation_class = null;
    }

    public boolean isSetValidation_class() {
        return this.validation_class != null;
    }

    public void setValidation_classIsSet(boolean value) {
        if (!value) {
            this.validation_class = null;
        }
    }

    public IndexType getIndex_type() {
        return this.index_type;
    }

    public ColumnDef setIndex_type(IndexType index_type) {
        this.index_type = index_type;
        return this;
    }

    public void unsetIndex_type() {
        this.index_type = null;
    }

    public boolean isSetIndex_type() {
        return this.index_type != null;
    }

    public void setIndex_typeIsSet(boolean value) {
        if (!value) {
            this.index_type = null;
        }
    }

    public String getIndex_name() {
        return this.index_name;
    }

    public ColumnDef setIndex_name(String index_name) {
        this.index_name = index_name;
        return this;
    }

    public void unsetIndex_name() {
        this.index_name = null;
    }

    public boolean isSetIndex_name() {
        return this.index_name != null;
    }

    public void setIndex_nameIsSet(boolean value) {
        if (!value) {
            this.index_name = null;
        }
    }

    public int getIndex_optionsSize() {
        return this.index_options == null ? 0 : this.index_options.size();
    }

    public void putToIndex_options(String key, String val) {
        if (this.index_options == null) {
            this.index_options = new HashMap<String, String>();
        }
        this.index_options.put(key, val);
    }

    public Map<String, String> getIndex_options() {
        return this.index_options;
    }

    public ColumnDef setIndex_options(Map<String, String> index_options) {
        this.index_options = index_options;
        return this;
    }

    public void unsetIndex_options() {
        this.index_options = null;
    }

    public boolean isSetIndex_options() {
        return this.index_options != null;
    }

    public void setIndex_optionsIsSet(boolean value) {
        if (!value) {
            this.index_options = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((ByteBuffer)value);
                break;
            }
            case VALIDATION_CLASS: {
                if (value == null) {
                    this.unsetValidation_class();
                    break;
                }
                this.setValidation_class((String)value);
                break;
            }
            case INDEX_TYPE: {
                if (value == null) {
                    this.unsetIndex_type();
                    break;
                }
                this.setIndex_type((IndexType)((Object)value));
                break;
            }
            case INDEX_NAME: {
                if (value == null) {
                    this.unsetIndex_name();
                    break;
                }
                this.setIndex_name((String)value);
                break;
            }
            case INDEX_OPTIONS: {
                if (value == null) {
                    this.unsetIndex_options();
                    break;
                }
                this.setIndex_options((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case VALIDATION_CLASS: {
                return this.getValidation_class();
            }
            case INDEX_TYPE: {
                return this.getIndex_type();
            }
            case INDEX_NAME: {
                return this.getIndex_name();
            }
            case INDEX_OPTIONS: {
                return this.getIndex_options();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case VALIDATION_CLASS: {
                return this.isSetValidation_class();
            }
            case INDEX_TYPE: {
                return this.isSetIndex_type();
            }
            case INDEX_NAME: {
                return this.isSetIndex_name();
            }
            case INDEX_OPTIONS: {
                return this.isSetIndex_options();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ColumnDef) {
            return this.equals((ColumnDef)that);
        }
        return false;
    }

    public boolean equals(ColumnDef that) {
        if (that == null) {
            return false;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_validation_class = this.isSetValidation_class();
        boolean that_present_validation_class = that.isSetValidation_class();
        if (this_present_validation_class || that_present_validation_class) {
            if (!this_present_validation_class || !that_present_validation_class) {
                return false;
            }
            if (!this.validation_class.equals(that.validation_class)) {
                return false;
            }
        }
        boolean this_present_index_type = this.isSetIndex_type();
        boolean that_present_index_type = that.isSetIndex_type();
        if (this_present_index_type || that_present_index_type) {
            if (!this_present_index_type || !that_present_index_type) {
                return false;
            }
            if (!this.index_type.equals((Object)that.index_type)) {
                return false;
            }
        }
        boolean this_present_index_name = this.isSetIndex_name();
        boolean that_present_index_name = that.isSetIndex_name();
        if (this_present_index_name || that_present_index_name) {
            if (!this_present_index_name || !that_present_index_name) {
                return false;
            }
            if (!this.index_name.equals(that.index_name)) {
                return false;
            }
        }
        boolean this_present_index_options = this.isSetIndex_options();
        boolean that_present_index_options = that.isSetIndex_options();
        if (this_present_index_options || that_present_index_options) {
            if (!this_present_index_options || !that_present_index_options) {
                return false;
            }
            if (!this.index_options.equals(that.index_options)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_name = this.isSetName();
        builder.append(present_name);
        if (present_name) {
            builder.append((Object)this.name);
        }
        boolean present_validation_class = this.isSetValidation_class();
        builder.append(present_validation_class);
        if (present_validation_class) {
            builder.append((Object)this.validation_class);
        }
        boolean present_index_type = this.isSetIndex_type();
        builder.append(present_index_type);
        if (present_index_type) {
            builder.append(this.index_type.getValue());
        }
        boolean present_index_name = this.isSetIndex_name();
        builder.append(present_index_name);
        if (present_index_name) {
            builder.append((Object)this.index_name);
        }
        boolean present_index_options = this.isSetIndex_options();
        builder.append(present_index_options);
        if (present_index_options) {
            builder.append(this.index_options);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(ColumnDef other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((Comparable)this.name, (Comparable)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValidation_class()).compareTo(other.isSetValidation_class());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidation_class() && (lastComparison = TBaseHelper.compareTo((String)this.validation_class, (String)other.validation_class)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndex_type()).compareTo(other.isSetIndex_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndex_type() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.index_type), (Comparable)((Object)other.index_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndex_name()).compareTo(other.isSetIndex_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndex_name() && (lastComparison = TBaseHelper.compareTo((String)this.index_name, (String)other.index_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndex_options()).compareTo(other.isSetIndex_options());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndex_options() && (lastComparison = TBaseHelper.compareTo(this.index_options, other.index_options)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnDef(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.name, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("validation_class:");
        if (this.validation_class == null) {
            sb.append("null");
        } else {
            sb.append(this.validation_class);
        }
        first = false;
        if (this.isSetIndex_type()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("index_type:");
            if (this.index_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.index_type);
            }
            first = false;
        }
        if (this.isSetIndex_name()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("index_name:");
            if (this.index_name == null) {
                sb.append("null");
            } else {
                sb.append(this.index_name);
            }
            first = false;
        }
        if (this.isSetIndex_options()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("index_options:");
            if (this.index_options == null) {
                sb.append("null");
            } else {
                sb.append(this.index_options);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.name == null) {
            throw new TProtocolException("Required field 'name' was not present! Struct: " + this.toString());
        }
        if (this.validation_class == null) {
            throw new TProtocolException("Required field 'validation_class' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ColumnDefStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ColumnDefTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.VALIDATION_CLASS, new FieldMetaData("validation_class", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.INDEX_TYPE, new FieldMetaData("index_type", 2, (FieldValueMetaData)new EnumMetaData(16, IndexType.class)));
        tmpMap.put(_Fields.INDEX_NAME, new FieldMetaData("index_name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.INDEX_OPTIONS, new FieldMetaData("index_options", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ColumnDef.class, metaDataMap);
    }

    private static class ColumnDefTupleScheme
    extends TupleScheme<ColumnDef> {
        private ColumnDefTupleScheme() {
        }

        public void write(TProtocol prot, ColumnDef struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.name);
            oprot.writeString(struct.validation_class);
            BitSet optionals = new BitSet();
            if (struct.isSetIndex_type()) {
                optionals.set(0);
            }
            if (struct.isSetIndex_name()) {
                optionals.set(1);
            }
            if (struct.isSetIndex_options()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetIndex_type()) {
                oprot.writeI32(struct.index_type.getValue());
            }
            if (struct.isSetIndex_name()) {
                oprot.writeString(struct.index_name);
            }
            if (struct.isSetIndex_options()) {
                oprot.writeI32(struct.index_options.size());
                for (Map.Entry<String, String> _iter95 : struct.index_options.entrySet()) {
                    oprot.writeString(_iter95.getKey());
                    oprot.writeString(_iter95.getValue());
                }
            }
        }

        public void read(TProtocol prot, ColumnDef struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.name = iprot.readBinary();
            struct.setNameIsSet(true);
            struct.validation_class = iprot.readString();
            struct.setValidation_classIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.index_type = IndexType.findByValue(iprot.readI32());
                struct.setIndex_typeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.index_name = iprot.readString();
                struct.setIndex_nameIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map96 = new TMap(11, 11, iprot.readI32());
                struct.index_options = new HashMap<String, String>(2 * _map96.size);
                for (int _i97 = 0; _i97 < _map96.size; ++_i97) {
                    String _key98 = iprot.readString();
                    String _val99 = iprot.readString();
                    struct.index_options.put(_key98, _val99);
                }
                struct.setIndex_optionsIsSet(true);
            }
        }
    }

    private static class ColumnDefTupleSchemeFactory
    implements SchemeFactory {
        private ColumnDefTupleSchemeFactory() {
        }

        public ColumnDefTupleScheme getScheme() {
            return new ColumnDefTupleScheme();
        }
    }

    private static class ColumnDefStandardScheme
    extends StandardScheme<ColumnDef> {
        private ColumnDefStandardScheme() {
        }

        public void read(TProtocol iprot, ColumnDef struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readBinary();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.validation_class = iprot.readString();
                            struct.setValidation_classIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.index_type = IndexType.findByValue(iprot.readI32());
                            struct.setIndex_typeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.index_name = iprot.readString();
                            struct.setIndex_nameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 13) {
                            TMap _map90 = iprot.readMapBegin();
                            struct.index_options = new HashMap<String, String>(2 * _map90.size);
                            for (int _i91 = 0; _i91 < _map90.size; ++_i91) {
                                String _key92 = iprot.readString();
                                String _val93 = iprot.readString();
                                struct.index_options.put(_key92, _val93);
                            }
                            iprot.readMapEnd();
                            struct.setIndex_optionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ColumnDef struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeBinary(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.validation_class != null) {
                oprot.writeFieldBegin(VALIDATION_CLASS_FIELD_DESC);
                oprot.writeString(struct.validation_class);
                oprot.writeFieldEnd();
            }
            if (struct.index_type != null && struct.isSetIndex_type()) {
                oprot.writeFieldBegin(INDEX_TYPE_FIELD_DESC);
                oprot.writeI32(struct.index_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.index_name != null && struct.isSetIndex_name()) {
                oprot.writeFieldBegin(INDEX_NAME_FIELD_DESC);
                oprot.writeString(struct.index_name);
                oprot.writeFieldEnd();
            }
            if (struct.index_options != null && struct.isSetIndex_options()) {
                oprot.writeFieldBegin(INDEX_OPTIONS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.index_options.size()));
                for (Map.Entry<String, String> _iter94 : struct.index_options.entrySet()) {
                    oprot.writeString(_iter94.getKey());
                    oprot.writeString(_iter94.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ColumnDefStandardSchemeFactory
    implements SchemeFactory {
        private ColumnDefStandardSchemeFactory() {
        }

        public ColumnDefStandardScheme getScheme() {
            return new ColumnDefStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        VALIDATION_CLASS(2, "validation_class"),
        INDEX_TYPE(3, "index_type"),
        INDEX_NAME(4, "index_name"),
        INDEX_OPTIONS(5, "index_options");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return VALIDATION_CLASS;
                }
                case 3: {
                    return INDEX_TYPE;
                }
                case 4: {
                    return INDEX_NAME;
                }
                case 5: {
                    return INDEX_OPTIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

