/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.cassandra.utils.IMergeIterator;

public abstract class MergeIterator<In, Out>
extends AbstractIterator<Out>
implements IMergeIterator<In, Out> {
    protected final Reducer<In, Out> reducer;
    protected final List<? extends Iterator<In>> iterators;

    protected MergeIterator(List<? extends Iterator<In>> iters, Reducer<In, Out> reducer) {
        this.iterators = iters;
        this.reducer = reducer;
    }

    public static <In, Out> IMergeIterator<In, Out> get(List<? extends Iterator<In>> sources, Comparator<In> comparator, Reducer<In, Out> reducer) {
        if (sources.size() == 1) {
            return reducer.trivialReduceIsTrivial() ? new TrivialOneToOne<In, Out>(sources, reducer) : new OneToOne<In, Out>(sources, reducer);
        }
        return new ManyToOne<In, Out>(sources, comparator, reducer);
    }

    @Override
    public Iterable<? extends Iterator<In>> iterators() {
        return this.iterators;
    }

    @Override
    public void close() {
        for (Iterator<In> iterator : this.iterators) {
            try {
                ((Closeable)((Object)iterator)).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.reducer.close();
    }

    private static class TrivialOneToOne<In, Out>
    extends MergeIterator<In, Out> {
        private final Iterator<In> source;

        public TrivialOneToOne(List<? extends Iterator<In>> sources, Reducer<In, Out> reducer) {
            super(sources, reducer);
            this.source = sources.get(0);
        }

        protected Out computeNext() {
            if (!this.source.hasNext()) {
                return (Out)this.endOfData();
            }
            return (Out)this.source.next();
        }
    }

    private static class OneToOne<In, Out>
    extends MergeIterator<In, Out> {
        private final Iterator<In> source;

        public OneToOne(List<? extends Iterator<In>> sources, Reducer<In, Out> reducer) {
            super(sources, reducer);
            this.source = sources.get(0);
        }

        protected Out computeNext() {
            if (!this.source.hasNext()) {
                return (Out)this.endOfData();
            }
            this.reducer.onKeyChange();
            this.reducer.reduce(this.source.next());
            return this.reducer.getReduced();
        }
    }

    public static abstract class Reducer<In, Out> {
        public boolean trivialReduceIsTrivial() {
            return false;
        }

        public abstract void reduce(In var1);

        protected abstract Out getReduced();

        protected void onKeyChange() {
        }

        public void close() {
        }
    }

    protected static final class Candidate<In>
    implements Comparable<Candidate<In>> {
        private final Iterator<In> iter;
        private final Comparator<In> comp;
        private In item;

        public Candidate(Iterator<In> iter, Comparator<In> comp) {
            this.iter = iter;
            this.comp = comp;
        }

        protected boolean advance() {
            if (!this.iter.hasNext()) {
                return false;
            }
            this.item = this.iter.next();
            return true;
        }

        @Override
        public int compareTo(Candidate<In> that) {
            return this.comp.compare(this.item, that.item);
        }
    }

    private static final class ManyToOne<In, Out>
    extends MergeIterator<In, Out> {
        protected final PriorityQueue<Candidate<In>> queue;
        protected final ArrayDeque<Candidate<In>> candidates;

        public ManyToOne(List<? extends Iterator<In>> iters, Comparator<In> comp, Reducer<In, Out> reducer) {
            super(iters, reducer);
            this.queue = new PriorityQueue(Math.max(1, iters.size()));
            for (Iterator<In> iter : iters) {
                Candidate<In> candidate = new Candidate<In>(iter, comp);
                if (!candidate.advance()) continue;
                this.queue.add(candidate);
            }
            this.candidates = new ArrayDeque(this.queue.size());
        }

        protected final Out computeNext() {
            this.advance();
            return this.consume();
        }

        protected final Out consume() {
            this.reducer.onKeyChange();
            Candidate<In> candidate = this.queue.peek();
            if (candidate == null) {
                return (Out)this.endOfData();
            }
            do {
                candidate = this.queue.poll();
                this.candidates.push(candidate);
                this.reducer.reduce(((Candidate)candidate).item);
            } while (this.queue.peek() != null && this.queue.peek().compareTo(candidate) == 0);
            return this.reducer.getReduced();
        }

        protected final void advance() {
            Candidate<In> candidate;
            while ((candidate = this.candidates.pollFirst()) != null) {
                if (!candidate.advance()) continue;
                this.queue.add(candidate);
            }
        }
    }
}

