/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.jmx.JMXNotificationProgressListener;

public class RepairRunner
extends JMXNotificationProgressListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final PrintStream out;
    private final StorageServiceMBean ssProxy;
    private final String keyspace;
    private final Map<String, String> options;
    private final Condition condition = new SimpleCondition();
    private int cmd;
    private volatile boolean hasNotificationLost;
    private volatile Exception error;

    public RepairRunner(PrintStream out, StorageServiceMBean ssProxy, String keyspace, Map<String, String> options) {
        this.out = out;
        this.ssProxy = ssProxy;
        this.keyspace = keyspace;
        this.options = options;
    }

    public void run() throws Exception {
        this.cmd = this.ssProxy.repairAsync(this.keyspace, this.options);
        if (this.cmd <= 0) {
            String message = String.format("[%s] Nothing to repair for keyspace '%s'", this.format.format(System.currentTimeMillis()), this.keyspace);
            this.out.println(message);
        } else {
            this.condition.await();
            if (this.error != null) {
                throw this.error;
            }
            if (this.hasNotificationLost) {
                this.out.println(String.format("There were some lost notification(s). You should check server log for repair status of keyspace %s", this.keyspace));
            }
        }
    }

    @Override
    public boolean isInterestedIn(String tag) {
        return tag.equals("repair:" + this.cmd);
    }

    @Override
    public void handleNotificationLost(long timestamp, String message) {
        this.hasNotificationLost = true;
    }

    @Override
    public void handleConnectionClosed(long timestamp, String message) {
        this.handleConnectionFailed(timestamp, message);
    }

    @Override
    public void handleConnectionFailed(long timestamp, String message) {
        this.error = new IOException(String.format("[%s] JMX connection closed. You should check server log for repair status of keyspace %s(Subsequent keyspaces are not going to be repaired).", this.format.format(timestamp), this.keyspace));
        this.condition.signalAll();
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        ProgressEventType type = event.getType();
        String message = String.format("[%s] %s", this.format.format(System.currentTimeMillis()), event.getMessage());
        if (type == ProgressEventType.PROGRESS) {
            message = message + " (progress: " + (int)event.getProgressPercentage() + "%)";
        }
        this.out.println(message);
        if (type == ProgressEventType.COMPLETE) {
            this.condition.signalAll();
        }
    }
}

