/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public interface Composite
extends IMeasurableMemory {
    public int size();

    public boolean isEmpty();

    public ByteBuffer get(int var1);

    public EOC eoc();

    public Composite withEOC(EOC var1);

    public Composite start();

    public Composite end();

    public ColumnSlice slice();

    public boolean isStatic();

    public boolean isPrefixOf(CType var1, Composite var2);

    public ByteBuffer toByteBuffer();

    public int dataSize();

    public Composite copy(CFMetaData var1, AbstractAllocator var2);

    public static enum EOC {
        START(-1),
        NONE(-1),
        END(1);

        public final int prefixComparisonResult;

        private EOC(int prefixComparisonResult) {
            this.prefixComparisonResult = prefixComparisonResult;
        }

        public static EOC from(int eoc) {
            return eoc == 0 ? NONE : (eoc < 0 ? START : END);
        }
    }
}

