/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnrecognizedEntityException;

public abstract class Relation {
    protected Operator relationType;

    public Operator operator() {
        return this.relationType;
    }

    public boolean isMultiColumn() {
        return false;
    }

    public boolean onToken() {
        return false;
    }

    public final boolean isContains() {
        return this.relationType == Operator.CONTAINS;
    }

    public final boolean isContainsKey() {
        return this.relationType == Operator.CONTAINS_KEY;
    }

    public final boolean isIN() {
        return this.relationType == Operator.IN;
    }

    public final boolean isEQ() {
        return this.relationType == Operator.EQ;
    }

    public final boolean isSlice() {
        return this.relationType == Operator.GT || this.relationType == Operator.GTE || this.relationType == Operator.LTE || this.relationType == Operator.LT;
    }

    public final Restriction toRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        switch (this.relationType) {
            case EQ: {
                return this.newEQRestriction(cfm, boundNames);
            }
            case LT: {
                return this.newSliceRestriction(cfm, boundNames, Bound.END, false);
            }
            case LTE: {
                return this.newSliceRestriction(cfm, boundNames, Bound.END, true);
            }
            case GTE: {
                return this.newSliceRestriction(cfm, boundNames, Bound.START, true);
            }
            case GT: {
                return this.newSliceRestriction(cfm, boundNames, Bound.START, false);
            }
            case IN: {
                return this.newINRestriction(cfm, boundNames);
            }
            case CONTAINS: {
                return this.newContainsRestriction(cfm, boundNames, false);
            }
            case CONTAINS_KEY: {
                return this.newContainsRestriction(cfm, boundNames, true);
            }
        }
        throw RequestValidations.invalidRequest("Unsupported \"!=\" relation: %s", this);
    }

    protected abstract Restriction newEQRestriction(CFMetaData var1, VariableSpecifications var2) throws InvalidRequestException;

    protected abstract Restriction newINRestriction(CFMetaData var1, VariableSpecifications var2) throws InvalidRequestException;

    protected abstract Restriction newSliceRestriction(CFMetaData var1, VariableSpecifications var2, Bound var3, boolean var4) throws InvalidRequestException;

    protected abstract Restriction newContainsRestriction(CFMetaData var1, VariableSpecifications var2, boolean var3) throws InvalidRequestException;

    protected abstract Term toTerm(List<? extends ColumnSpecification> var1, Term.Raw var2, String var3, VariableSpecifications var4) throws InvalidRequestException;

    protected final List<Term> toTerms(List<? extends ColumnSpecification> receivers, List<? extends Term.Raw> raws, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        if (raws == null) {
            return null;
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        int m = raws.size();
        for (int i = 0; i < m; ++i) {
            terms.add(this.toTerm(receivers, raws.get(i), keyspace, boundNames));
        }
        return terms;
    }

    protected final ColumnDefinition toColumnDefinition(CFMetaData cfm, ColumnIdentifier.Raw entity) throws InvalidRequestException {
        ColumnIdentifier identifier = entity.prepare(cfm);
        ColumnDefinition def = cfm.getColumnDefinition(identifier);
        if (def == null) {
            throw new UnrecognizedEntityException(identifier, this);
        }
        return def;
    }
}

