/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics.reporter.config.AbstractGangliaReporterConfig;
import com.addthis.metrics.reporter.config.HostPort;
import com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporterConfig
extends AbstractGangliaReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(GangliaReporterConfig.class);

    private void enableMetrics3(HostPort hostPort, MetricRegistry registry) throws IOException {
        GangliaReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRealRateunit()).convertDurationsTo(this.getRealDurationunit()).prefixedWith(this.groupPrefix).filter(MetricFilterTransformer.generateFilter(this.getPredicate())).build(new GMetric(hostPort.getHost(), hostPort.getPort(), GMetric.UDPAddressingMode.UNICAST, 1)).start(this.getPeriod(), this.getRealTimeunit());
    }

    @Override
    public boolean enable(MetricRegistry registry) {
        boolean success = this.setup("com.codahale.metrics.ganglia.GangliaReporter");
        if (!success) {
            return false;
        }
        List hosts = this.getFullHostList();
        for (HostPort hostPort : hosts) {
            log.info("Enabling GangliaReporter to {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort()});
            try {
                this.enableMetrics3(hostPort, registry);
            }
            catch (Exception e) {
                log.error("Faliure while enabling GangliaReporter", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

