/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryConsistencyException;

public class ReadFailureException
extends QueryConsistencyException {
    private final int failed;
    private final boolean dataPresent;

    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        super(String.format("Cassandra failure during read query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.failed = failed;
        this.dataPresent = dataPresent;
    }

    private ReadFailureException(String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        super(msg, cause, consistency, received, required);
        this.failed = failed;
        this.dataPresent = dataPresent;
    }

    public int getFailures() {
        return this.failed;
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public DriverException copy() {
        return new ReadFailureException(this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.wasDataRetrieved());
    }
}

