/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.NettyUtil;
import com.datastax.shaded.netty.bootstrap.Bootstrap;
import com.datastax.shaded.netty.buffer.PooledByteBufAllocator;
import com.datastax.shaded.netty.channel.ChannelOption;
import com.datastax.shaded.netty.channel.EventLoopGroup;
import com.datastax.shaded.netty.channel.socket.SocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NettyOptions {
    public static final NettyOptions DEFAULT_INSTANCE = new NettyOptions();

    public EventLoopGroup eventLoopGroup(ThreadFactory threadFactory) {
        return NettyUtil.newEventLoopGroupInstance(threadFactory);
    }

    public Class<? extends SocketChannel> channelClass() {
        return NettyUtil.channelClass();
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public void afterChannelInitialized(SocketChannel channel) throws Exception {
    }

    public void onClusterClose(EventLoopGroup eventLoopGroup) {
        eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).syncUninterruptibly();
    }
}

