/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BatchStatement
extends Statement {
    final Type batchType;
    private final List<Statement> statements = new ArrayList<Statement>();

    public BatchStatement() {
        this(Type.LOGGED);
    }

    public BatchStatement(Type batchType) {
        this.batchType = batchType;
    }

    IdAndValues getIdAndValues(ProtocolVersion protocolVersion) {
        IdAndValues idAndVals = new IdAndValues(this.statements.size());
        for (Statement statement : this.statements) {
            Statement st;
            if (statement instanceof RegularStatement) {
                st = (RegularStatement)statement;
                ByteBuffer[] vals = ((RegularStatement)st).getValues(protocolVersion);
                idAndVals.ids.add(((RegularStatement)st).getQueryString());
                idAndVals.values.add(vals == null ? Collections.emptyList() : Arrays.asList(vals));
                continue;
            }
            assert (statement instanceof BoundStatement);
            st = (BoundStatement)statement;
            idAndVals.ids.add(((BoundStatement)st).statement.getPreparedId().id);
            idAndVals.values.add(Arrays.asList(((BoundStatement)st).wrapper.values));
        }
        return idAndVals;
    }

    public BatchStatement add(Statement statement) {
        if (statement instanceof BatchStatement) {
            for (Statement subStatements : ((BatchStatement)statement).statements) {
                this.add(subStatements);
            }
        } else {
            if (this.statements.size() >= 65535) {
                throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
            }
            this.statements.add(statement);
        }
        return this;
    }

    public BatchStatement addAll(Iterable<? extends Statement> statements) {
        for (Statement statement : statements) {
            this.add(statement);
        }
        return this;
    }

    public Collection<Statement> getStatements() {
        return ImmutableList.copyOf(this.statements);
    }

    public BatchStatement clear() {
        this.statements.clear();
        return this;
    }

    public int size() {
        return this.statements.size();
    }

    @Override
    public BatchStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        return (BatchStatement)super.setSerialConsistencyLevel(serialConsistency);
    }

    @Override
    public ByteBuffer getRoutingKey() {
        for (Statement statement : this.statements) {
            ByteBuffer rk = statement.getRoutingKey();
            if (rk == null) continue;
            return rk;
        }
        return null;
    }

    @Override
    public String getKeyspace() {
        for (Statement statement : this.statements) {
            String keyspace = statement.getKeyspace();
            if (keyspace == null) continue;
            return keyspace;
        }
        return null;
    }

    void ensureAllSet() {
        for (Statement statement : this.statements) {
            if (!(statement instanceof BoundStatement)) continue;
            ((BoundStatement)statement).ensureAllSet();
        }
    }

    static class IdAndValues {
        public final List<Object> ids;
        public final List<List<ByteBuffer>> values;

        IdAndValues(int nbstatements) {
            this.ids = new ArrayList<Object>(nbstatements);
            this.values = new ArrayList<List<ByteBuffer>>(nbstatements);
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

