/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class SampleOfLongs {
    final long[] sample;
    final double p;

    SampleOfLongs(long[] sample, int p) {
        this.sample = sample;
        this.p = 1.0f / (float)p;
    }

    SampleOfLongs(long[] sample, double p) {
        this.sample = sample;
        this.p = p;
    }

    /*
     * WARNING - void declaration
     */
    static SampleOfLongs merge(Random rnd, List<SampleOfLongs> merge, int maxSamples) {
        void var6_10;
        double targetp = 1.0;
        for (SampleOfLongs sampleOfLongs : merge) {
            targetp = Math.min(targetp, sampleOfLongs.p);
        }
        int maxLength = 0;
        for (SampleOfLongs sampleOfLongs : merge) {
            maxLength = (int)((double)maxLength + (double)sampleOfLongs.sample.length * (targetp / sampleOfLongs.p));
        }
        if (maxLength > maxSamples) {
            targetp *= (double)maxSamples / (double)maxLength;
            maxLength = maxSamples;
        }
        long[] lArray = new long[maxLength];
        int count = 0;
        block2: for (SampleOfLongs latencies : merge) {
            long[] in = latencies.sample;
            double p = targetp / latencies.p;
            for (int i = 0; i < in.length; ++i) {
                if (!(rnd.nextDouble() < p)) continue;
                lArray[count++] = in[i];
                if (count == maxLength) break block2;
            }
        }
        if (count != maxLength) {
            long[] lArray2 = Arrays.copyOf(lArray, count);
        }
        Arrays.sort((long[])var6_10);
        return new SampleOfLongs((long[])var6_10, targetp);
    }

    public double medianLatency() {
        if (this.sample.length == 0) {
            return 0.0;
        }
        return (double)this.sample[this.sample.length >> 1] * 1.0E-6;
    }

    public double rankLatency(float rank) {
        if (this.sample.length == 0) {
            return 0.0;
        }
        int index = (int)(rank * (float)this.sample.length);
        if (index >= this.sample.length) {
            index = this.sample.length - 1;
        }
        return (double)this.sample[index] * 1.0E-6;
    }
}

