/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public class HeadCropTrimmer
extends AbstractSingleRecordTrimmer {
    private int bases;
    private int maxLength = 0x3FFFFFFF;

    public HeadCropTrimmer(String args) {
        String[] arg = args.split(":");
        this.bases = Integer.parseInt(arg[0]);
        if (arg.length > 1) {
            this.maxLength = Integer.parseInt(arg[1]);
        }
    }

    public FastqRecord processRecord(FastqRecord in) {
        int toTrim;
        int len = in.getSequence().length();
        int overLen = len - (toTrim = this.bases) - this.maxLength;
        if (overLen > 0) {
            toTrim += overLen;
        }
        if (len <= toTrim) {
            return null;
        }
        if (toTrim == 0) {
            return in;
        }
        return new FastqRecord(in, toTrim, len - toTrim);
    }
}

