/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.openide.util.NbBundle;

class JFRStopAction
extends MultiDataSourceAction<DataSource> {
    private static JFRStopAction INSTANCE;
    private Set<Application> lastSelectedApplications = new HashSet<Application>();
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JFRStopAction.this.updateState(ActionUtils.getSelectedDataSources());
        }
    };

    public static synchronized JFRStopAction instance() {
        if (INSTANCE == null) {
            INSTANCE = new JFRStopAction();
        }
        return INSTANCE;
    }

    private JFRStopAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(JFRStopAction.class, (String)"MSG_JFR_Stop"));
        this.putValue("ShortDescription", NbBundle.getMessage(JFRStopAction.class, (String)"LBL_JFR_Stop"));
    }

    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        for (DataSource dataSource : dataSources) {
            if (!(dataSource instanceof Application)) continue;
            Application application = (Application)dataSource;
            if (application.isLocalApplication()) {
                JFRSnapshotSupport.jfrStopRecording(application);
            } else {
                JFRSnapshotSupport.remoteJfrStopRecording(application);
            }
            this.updateState(dataSources);
        }
    }

    protected boolean isEnabled(Set<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                Application application = (Application)dataSource;
                this.lastSelectedApplications.add(application);
                application.addPropertyChangeListener("prop_state", this.stateListener);
                if (application.getState() != 1) {
                    return false;
                }
                if (!(application.isLocalApplication() ? !JFRSnapshotSupport.supportsJfrStop(application) : !JFRSnapshotSupport.supportsRemoteJfrStop(application))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected void updateState(Set<DataSource> dataSources) {
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.removePropertyChangeListener("prop_state", this.stateListener);
            }
        }
        this.lastSelectedApplications.clear();
        super.updateState(dataSources);
    }
}

