/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IToolkitBeepHelper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ToolkitBeepHelper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils2;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseDataTypeComponent
implements IDataTypeComponent {
    private static ILogger s_log = LoggerController.createLogger(BaseDataTypeComponent.class);
    protected ColumnDisplayDefinition _colDef;
    protected JTable _table;
    protected DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    protected RestorableJTextField _textField;
    protected RestorableJTextArea _textArea;
    protected IToolkitBeepHelper _beepHelper = new ToolkitBeepHelper();
    public static final String NULL_VALUE_PATTERN = "<null>";

    @Override
    public void setColumnDisplayDefinition(ColumnDisplayDefinition def) {
        this._colDef = def;
    }

    @Override
    public void setTable(JTable table) {
        this._table = table;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textArea = new RestorableJTextArea();
        this._textArea.setText((String)this._renderer.renderObject(value));
        KeyListener keyListener = this.getKeyListener(this._textArea);
        if (keyListener != null) {
            this._textArea.addKeyListener(keyListener);
        }
        return this._textArea;
    }

    @Override
    public JTextField getJTextField() {
        this._textField = new RestorableJTextField();
        KeyListener keyListener = this.getKeyListener(this._textField);
        if (keyListener != null) {
            this._textField.addKeyListener(keyListener);
        }
        this._textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent(BaseDataTypeComponent.this._textField, evt, BaseDataTypeComponent.this._table);
                    CellDataPopup.showDialog(BaseDataTypeComponent.this._table, BaseDataTypeComponent.this._colDef, tableEvt, true);
                }
            }
        });
        return this._textField;
    }

    @Override
    public String renderObject(Object value) {
        String text = (String)this._renderer.renderObject(value);
        return text;
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals(NULL_VALUE_PATTERN)) {
            return null;
        }
        return value;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    protected KeyListener getKeyListener(IRestorableTextComponent component) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(outStream);
            outWriter.write(text);
            outWriter.flush();
            outWriter.close();
        }
        finally {
            if (outWriter != null) {
                try {
                    outWriter.close();
                }
                catch (IOException e) {
                    s_log.error("exportObject: Unexpected exception: " + e, e);
                }
            }
        }
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public void setBeepHelper(IToolkitBeepHelper helper) {
        this._beepHelper = helper;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    @Override
    public String getCondition(String column, String operator, String value) {
        if (operator.equals("IN") && !value.trim().startsWith("(")) {
            value = "(" + value + ")";
        } else if (value != null && value.length() > 0) {
            value = this.quoteTextConditionValue(value);
        }
        StringBuilder result = new StringBuilder();
        result.append(column).append(" ").append(operator);
        if (value != null && value.length() > 0) {
            result.append(" " + value);
        }
        return result.toString();
    }

    protected String quoteTextConditionValue(String value) {
        return value;
    }

    @Override
    public String[] getSupportedOperators() {
        return new String[]{"=", "<>", ">", "<", ">=", "<=", "IN", "LIKE", "IS NULL", "IS NOT NULL"};
    }

    @Override
    public boolean areEqual(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        if (obj2 != null) {
            return obj2.equals(obj1);
        }
        return true;
    }

    @Override
    public String getColumnForContentSelect(DialectType dialectType, String columnPrefix) {
        return columnPrefix + DialectUtils2.checkColumnDoubleQuotes(dialectType, this._colDef.getColumnName());
    }
}

