/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel.completions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Completion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLCompletion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLColumn;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatementContext;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLTable;

public class SQLStatement
extends SQLCompletion
implements SQLSchema,
SQLStatementContext {
    private SortedSet<Completion> children;
    protected SQLSchema sqlSchema;
    private static final List<Completion> EMPTY_LIST = new ArrayList<Completion>();

    public SQLStatement(int start) {
        super(start);
    }

    @Override
    public Completion getCompletion(int position) {
        if (this.isEnclosed(position)) {
            Iterator<Completion> it = this.getChildren();
            while (it.hasNext()) {
                Completion c = it.next().getCompletion(position);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public void setSqlSchema(SQLSchema schema) {
        if (schema == this) {
            throw new RuntimeException("internal error: recursive schema");
        }
        this.sqlSchema = schema;
    }

    protected void addChild(Completion child) {
        if (this.children == null) {
            this.children = new TreeSet<SQLCompletion>(new SQLCompletion.ChildComparator());
        }
        this.children.add(child);
    }

    @Override
    public void addContext(SQLStatementContext context) {
        context.setSqlSchema(this);
        this.addChild(context);
    }

    @Override
    public void setEndPosition(int offset) {
        super.setEndPosition(offset);
        if (this.sqlSchema instanceof SQLStatement) {
            ((SQLStatement)this.sqlSchema).setEndPosition(offset);
        }
    }

    public void addTable(SQLTable table) {
        this.addChild(table);
    }

    public boolean setTable(SQLTable table) {
        return this.setTable(table.catalog, table.schema, table.name, table.alias);
    }

    public boolean setTable(String catalog, String schema, String name, String alias) {
        return this.sqlSchema.getTable(catalog, schema, name) != null;
    }

    @Override
    public SQLSchema.Table getTable(String catalog, String schema, String name) {
        return this.sqlSchema.getTable(catalog, schema, name);
    }

    @Override
    public List<SQLSchema.Table> getTables(String catalog, String schema, String name) {
        return this.sqlSchema.getTables(catalog, schema, name);
    }

    @Override
    public SQLSchema.Table getTableForAlias(String alias) {
        return this.sqlSchema.getTableForAlias(alias);
    }

    @Override
    public void addColumn(SQLColumn column) {
        this.addChild(column);
    }

    @Override
    public SQLStatement getStatement() {
        return this;
    }

    protected Iterator<Completion> getChildren() {
        return this.children != null ? this.children.iterator() : EMPTY_LIST.iterator();
    }

    public SQLSchema.Table getTable() {
        return null;
    }
}

