/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyResultTabControllerFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyTabControllerCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;

public class LazyResultTabInitializer<T extends LazyTabControllerCtrl> {
    private final ISession _session;
    private final JTabbedPane _tabResultTabs;
    private Integer tabIndex = null;
    private ResultSetDataSet _rsds;
    private T _lazyTabController;
    private boolean _isInitialized = false;
    private LazyResultTabControllerFactory _lazyResultTabControllerFactory;

    public LazyResultTabInitializer(ISession session, JTabbedPane tabResultTabs, LazyResultTabControllerFactory<T> lazyResultTabControllerFactory) {
        this._session = session;
        this._tabResultTabs = tabResultTabs;
        this._lazyResultTabControllerFactory = lazyResultTabControllerFactory;
        this._tabResultTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LazyResultTabInitializer.this.onStateChanged();
            }
        });
    }

    private void onStateChanged() {
        if (this._isInitialized || null == this.tabIndex || null == this._tabResultTabs || null == this._rsds) {
            return;
        }
        if (this.tabIndex.intValue() == this._tabResultTabs.getSelectedIndex()) {
            this._lazyTabController.init(this._rsds);
            this._isInitialized = true;
        }
    }

    public void initTab() {
        if (null != this.tabIndex && this.tabIndex < this._tabResultTabs.getTabCount() && this._lazyResultTabControllerFactory.isMatchingPanel(this._tabResultTabs.getComponentAt(this.tabIndex))) {
            this._tabResultTabs.removeTabAt(this.tabIndex);
        }
        if (null == this.tabIndex) {
            this.tabIndex = this._tabResultTabs.getTabCount();
        }
        this._lazyTabController = this._lazyResultTabControllerFactory.create();
        this._tabResultTabs.insertTab(this._lazyTabController.getTitle(), null, this._lazyTabController.getPanel(), null, this.tabIndex);
    }

    public void setCurrentResult(ResultSetDataSet rsds) {
        this._rsds = rsds;
        this._isInitialized = false;
    }

    public void moreResultsHaveBeenRead() {
        this.initTab();
        this.setCurrentResult(this._rsds);
    }
}

