/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;

public class AliasFolderState
implements Comparable<AliasFolderState> {
    private AliasFolderState[] _kids = new AliasFolderState[0];
    private IIdentifier _aliasIdentifier;
    private String _folderName;
    private boolean _isSelected;
    private boolean _isExpanded;
    private DefaultMutableTreeNode _node;
    private String _aliasName;

    public AliasFolderState() {
    }

    public AliasFolderState(DefaultMutableTreeNode dmtn, JTree tree) {
        TreePath selPath = tree.getSelectionPath();
        if (null != selPath && selPath.getLastPathComponent() == dmtn) {
            this._isSelected = true;
        }
        this._isExpanded = tree.isExpanded(new TreePath(dmtn.getPath()));
        if (dmtn.getUserObject() instanceof ISQLAlias) {
            ISQLAlias alias = (ISQLAlias)dmtn.getUserObject();
            this._aliasIdentifier = alias.getIdentifier();
            this._aliasName = alias.getName();
        } else {
            this._folderName = dmtn.getUserObject().toString();
            this._kids = new AliasFolderState[dmtn.getChildCount()];
            for (int i = 0; i < dmtn.getChildCount(); ++i) {
                AliasFolderState state;
                this._kids[i] = state = new AliasFolderState((DefaultMutableTreeNode)dmtn.getChildAt(i), tree);
            }
        }
    }

    public AliasFolderState[] getKids() {
        return this._kids;
    }

    public void setKids(AliasFolderState[] kids) {
        this._kids = kids;
    }

    public IIdentifier getAliasIdentifier() {
        return this._aliasIdentifier;
    }

    public void setAliasIdentifier(IIdentifier aliasIdentifier) {
        this._aliasIdentifier = aliasIdentifier;
    }

    public String getFolderName() {
        return this._folderName;
    }

    public void setFolderName(String folderName) {
        this._folderName = folderName;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean selected) {
        this._isSelected = selected;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this._isExpanded = expanded;
    }

    public void applyNodes(DefaultMutableTreeNode parent, AliasesListModel aliasesListModel) {
        if (null != this._folderName) {
            this._node = GUIUtils.createFolderNode(this._folderName);
            parent.add(this._node);
            for (AliasFolderState kid : this._kids) {
                kid.applyNodes(this._node, aliasesListModel);
            }
        } else {
            SQLAlias sqlAlias = aliasesListModel.getAlias(this._aliasIdentifier);
            if (null != sqlAlias) {
                this._node = new DefaultMutableTreeNode(sqlAlias);
                parent.add(this._node);
            }
        }
    }

    private void applyExpansionAndSelectionToNode(JTree tree, DefaultMutableTreeNode node) {
        if (this._isExpanded) {
            tree.expandPath(new TreePath(node.getPath()));
        }
        if (this._isSelected) {
            tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void applyExpansionAndSelection(JTree tree) {
        if (this._node != null) {
            if (null != this._folderName) {
                this.applyExpansionAndSelectionToNode(tree, this._node);
                for (AliasFolderState kid : this._kids) {
                    kid.applyExpansionAndSelection(tree);
                }
            } else {
                this.applyExpansionAndSelectionToNode(tree, this._node);
            }
        }
    }

    public void sort() {
        Arrays.sort(this._kids);
        for (AliasFolderState kid : this._kids) {
            kid.sort();
        }
    }

    @Override
    public int compareTo(AliasFolderState other) {
        if (null == this._aliasIdentifier && null != other._aliasIdentifier) {
            return -1;
        }
        if (null != this._aliasIdentifier && null == other._aliasIdentifier) {
            return 1;
        }
        return this.getCompString().compareTo(other.getCompString());
    }

    private String getCompString() {
        return null != this._folderName ? this._folderName : this._aliasName;
    }
}

