/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private static final byte[][] WEAK_KEYS;
    private byte[] key;

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        boolean parity = false;
        boolean oddbits = false;
        int i = 0;
        while (i < 8) {
            oddbits = false;
            int j = 0;
            while (j < 8) {
                boolean bl = false;
                if ((key[i + offset] & 1 << j) != 0) {
                    bl = true;
                }
                oddbits ^= bl;
                ++j;
            }
            parity &= oddbits;
            ++i;
        }
        return parity;
    }

    public static boolean isWeak(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        int i = 0;
        while (i < WEAK_KEYS.length) {
            if (DESKeySpec.equalsOrComplementEquals(key, offset, WEAK_KEYS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean equalsOrComplementEquals(byte[] a, int off, byte[] b) {
        boolean result = true;
        int i = 0;
        while (i < 8) {
            boolean bl = false;
            if (a[off + i] == b[i]) {
                bl = true;
            }
            result &= bl;
            ++i;
        }
        if (result) {
            return true;
        }
        result = true;
        i = 0;
        while (i < 8) {
            boolean bl = false;
            if (a[off + i] == ~b[i]) {
                bl = true;
            }
            result &= bl;
            ++i;
        }
        return result;
    }

    public byte[] getKey() {
        return this.key;
    }

    public DESKeySpec(byte[] key) throws InvalidKeyException {
        this(key, 0);
    }

    public DESKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        this.key = new byte[8];
        System.arraycopy(key, offset, this.key, 0, 8);
    }

    static {
        byte[][] byArrayArray = new byte[10][];
        byArrayArray[0] = new byte[8];
        byte[] byArray = new byte[8];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArrayArray[1] = byArray;
        byArrayArray[2] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        byArrayArray[3] = new byte[]{31, 31, 31, 31, 14, 14, 14, 14};
        byArrayArray[4] = new byte[]{1, -2, 1, -2, 1, -2, 1, -2};
        byArrayArray[5] = new byte[]{31, -32, 31, -32, -32, 31, -32, 31};
        byArrayArray[6] = new byte[]{1, -32, 1, -32, 1, -15, 1, -15};
        byArrayArray[7] = new byte[]{31, -2, 31, -2, 14, -2, 14, -2};
        byArrayArray[8] = new byte[]{1, 31, 1, 31, 1, 14, 1, 14};
        byArrayArray[9] = new byte[]{-32, -2, -32, -2, -15, -2, -15, -2};
        WEAK_KEYS = byArrayArray;
    }
}

