/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Hashtable;
import java.util.Vector;
import org.sablecc.sablecc.CharSet;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.NFA;

public class DFA {
    public NFA nfa;
    public final Vector states = new Vector(0);
    public final Hashtable finder = new Hashtable(1);
    private IntSet[] eclosures;

    public DFA(NFA nfa) {
        this.nfa = nfa;
        this.construct();
        this.optimize();
    }

    private void optimize() {
        State state;
        int i;
        Vector transitions = new Vector(0);
        for (i = 0; i < this.states.size(); ++i) {
            state = (State)this.states.elementAt(i);
            transitions.addElement(new Vector(0));
            for (int j = 0; j < state.transitions.size(); ++j) {
                int max = 0;
                int st = -1;
                for (int k = 0; k < i; ++k) {
                    int match = this.match(i, j, k);
                    if (match <= max) continue;
                    max = match;
                    st = k;
                }
                if (max < 2) {
                    ((Vector)transitions.elementAt(i)).addElement(state.transitions.elementAt(j));
                    continue;
                }
                Transition transition1 = (Transition)state.transitions.elementAt(j);
                Transition transition2 = (Transition)state.transitions.elementAt(j + max - 1);
                Transition transition = new Transition(new CharSet.Interval(transition1.interval().start, transition2.interval().end), -2 - st);
                ((Vector)transitions.elementAt(i)).addElement(transition);
                j += max - 1;
            }
        }
        for (i = 0; i < this.states.size(); ++i) {
            state = (State)this.states.elementAt(i);
            state.transitions = (Vector)transitions.elementAt(i);
        }
    }

    private int match(int st1, int tr, int st2) {
        State state1 = (State)this.states.elementAt(st1);
        State state2 = (State)this.states.elementAt(st2);
        Transition first = (Transition)state1.transitions.elementAt(tr);
        int j = -1;
        for (int i = 0; i < state2.transitions.size(); ++i) {
            Transition transition = (Transition)state2.transitions.elementAt(i);
            if (!transition.match(first)) continue;
            j = i;
            break;
        }
        if (j == -1) {
            return 0;
        }
        int max = 0;
        for (int i = tr; i < state1.transitions.size() && j < state2.transitions.size(); ++i, ++j) {
            Transition transition2;
            Transition transition1 = (Transition)state1.transitions.elementAt(i);
            if (!transition1.match(transition2 = (Transition)state2.transitions.elementAt(j))) {
                return max;
            }
            ++max;
        }
        return max;
    }

    private void construct() {
        this.computeEClosures();
        IntSet initial = new IntSet();
        initial.or(this.eclosure(0));
        State state = new State(initial);
        this.states.addElement(state);
        this.finder.put(state.nfaStates, new Integer(0));
        int i = -1;
        while (++i < this.states.size()) {
            System.out.print(".");
            state = (State)this.states.elementAt(i);
            CharSet.Interval interval = new CharSet.Interval('\u0000', '\uffff');
            do {
                IntSet destination = new IntSet();
                interval.end = (char)65535;
                boolean modified = false;
                int[] elements = state.nfaStates.elements();
                for (int k = 0; k < elements.length; ++k) {
                    CharSet.Interval overlap;
                    int j = elements[k];
                    if (this.nfa.states[j].transitions[0] != null && this.nfa.states[j].transitions[0].chars != null && (overlap = this.nfa.states[j].transitions[0].chars.findOverlap(interval)) != null) {
                        if (overlap.start > interval.start) {
                            interval.end = (char)(overlap.start - '\u0001');
                        } else {
                            destination.set(this.nfa.states[j].transitions[0].destination);
                            modified = true;
                            if (overlap.end < interval.end) {
                                interval.end = overlap.end;
                            }
                        }
                    }
                    if (this.nfa.states[j].transitions[1] == null || this.nfa.states[j].transitions[1].chars == null || (overlap = this.nfa.states[j].transitions[1].chars.findOverlap(interval)) == null) continue;
                    if (overlap.start > interval.start) {
                        interval.end = (char)(overlap.start - '\u0001');
                        continue;
                    }
                    destination.set(this.nfa.states[j].transitions[1].destination);
                    if (overlap.end >= interval.end) continue;
                    interval.end = overlap.end;
                }
                if (modified) {
                    Integer dest = (Integer)this.finder.get(destination = this.eclosure(destination));
                    if (dest != null) {
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), dest));
                    } else {
                        State s = new State(destination);
                        this.states.addElement(s);
                        this.finder.put(s.nfaStates, new Integer(this.states.size() - 1));
                        state.transitions.addElement(new Transition((CharSet.Interval)interval.clone(), this.states.size() - 1));
                    }
                }
                interval.start = (char)(interval.end + '\u0001');
            } while (interval.end != '\uffff');
        }
    }

    private void computeEClosures() {
        this.eclosures = new IntSet[this.nfa.states.length];
        for (int i = 0; i < this.nfa.states.length; ++i) {
            System.out.print(".");
            IntSet set = new IntSet();
            this.eclosure(i, set);
            this.eclosures[i] = set;
        }
        System.out.println();
    }

    private IntSet eclosure(int state) {
        return this.eclosures[state];
    }

    private void eclosure(int state, IntSet nfaStates) {
        if (this.eclosures[state] != null) {
            nfaStates.or(this.eclosures[state]);
            return;
        }
        nfaStates.set(state);
        if (this.nfa.states[state].transitions[0] != null && this.nfa.states[state].transitions[0].chars == null && !nfaStates.get(this.nfa.states[state].transitions[0].destination)) {
            this.eclosure(this.nfa.states[state].transitions[0].destination, nfaStates);
        }
        if (this.nfa.states[state].transitions[1] != null && this.nfa.states[state].transitions[1].chars == null && !nfaStates.get(this.nfa.states[state].transitions[1].destination)) {
            this.eclosure(this.nfa.states[state].transitions[1].destination, nfaStates);
        }
    }

    private IntSet eclosure(IntSet nfaStates) {
        IntSet result = new IntSet();
        int[] elements = nfaStates.elements();
        for (int j = 0; j < elements.length; ++j) {
            int i = elements[j];
            result.or(this.eclosure(i));
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.states.size(); ++i) {
            result.append(i + ": " + this.states.elementAt(i) + System.getProperty("line.separator"));
        }
        return result.toString();
    }

    public static class Transition {
        private char start;
        private char end;
        public int destination;

        public Transition(CharSet.Interval interval, int destination) {
            this.start = interval.start;
            this.end = interval.end;
            this.destination = destination;
        }

        public CharSet.Interval interval() {
            return new CharSet.Interval(this.start, this.end);
        }

        public Transition(Transition transition) {
            this.start = transition.start;
            this.end = transition.end;
            this.destination = transition.destination;
        }

        public String toString() {
            return this.destination + ":[" + this.interval() + "]";
        }

        public boolean match(Transition transition) {
            return this.start == transition.start && this.end == transition.end && this.destination == transition.destination;
        }
    }

    public static class State {
        public IntSet nfaStates = new IntSet();
        public Vector transitions = new Vector(0);
        public int accept;

        public State(IntSet nfaStates) {
            this.nfaStates = nfaStates;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < this.transitions.size(); ++i) {
                result.append(this.transitions.elementAt(i) + ",");
            }
            return result + "";
        }
    }
}

